/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.ru.IntroductoryConstructions;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.SemanticRules;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;

class ComplexConjunctions {
    private static final String[] movableToRight = new String[]{"\u0442\u0430\u043a|\u043f\u043e\u0442\u043e\u043c\u0443", "\u0447\u0442\u043e"};
    public static final String[] nesmotryaNaToChto = new String[]{"\u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f", "\u043d\u0430", "\u0442\u043e", "\u0447\u0442\u043e"};
    public static final String[] ransheChemCherez = new String[]{"\u0440\u0430\u043d\u044c\u0448\u0435|\u0440\u0430\u043d\u0435\u0435", "\u0447\u0435\u043c", "\u0447\u0435\u0440\u0435\u0437|\u0437\u0430"};
    private static final NodePattern relativeMeasurement = SemanticRules.timeUnit.withHead("obl|advcl", NodePattern.N.form("\u0440\u0430\u043d\u044c\u0448\u0435|\u0440\u0430\u043d\u0435\u0435|\u043f\u043e\u0437\u0436\u0435|\u043f\u043e\u0437\u0434\u043d\u0435\u0435|\u0431\u043e\u043b\u044c\u0448\u0435|\u0431\u043e\u043b\u0435\u0435|\u043c\u0435\u043d\u044c\u0448\u0435|\u043c\u0435\u043d\u0435\u0435|\u0434\u043b\u0438\u043d\u043d\u0435\u0435|\u0434\u043e\u043b\u044c\u0448\u0435|\u043a\u043e\u0440\u043e\u0447\u0435|\u0431\u044b\u0441\u0442\u0440\u0435\u0435|\u043c\u0435\u0434\u043b\u0435\u043d\u043d\u0435\u0435"));
    private static final String[][] conditionallySplittable = new String[][]{{"\u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f", "\u043d\u0430", "\u0442\u043e", "\u0447\u0442\u043e"}, {"\u0432\u0432\u0438\u0434\u0443|\u043c\u0430\u043b\u043e", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0432", "\u0441\u043b\u0443\u0447\u0430\u0435", "\u0435\u0441\u043b\u0438|\u043a\u043e\u0433\u0434\u0430"}, {"\u043d\u0430", "\u0441\u043b\u0443\u0447\u0430\u0439", "\u0435\u0441\u043b\u0438|\u043a\u043e\u0433\u0434\u0430"}, {"\u043f\u0435\u0440\u0435\u0434", "\u0442\u0435\u043c", "\u043a\u0430\u043a"}, {"\u043f\u043e\u0434\u043e\u0431\u043d\u043e", "\u0442\u043e\u043c\u0443", "\u043a\u0430\u043a"}, {"\u043f\u0440\u0438", "\u0442\u043e\u043c", "\u0447\u0442\u043e"}, {"\u0434\u043b\u044f|\u0434\u043e|\u043f\u043e\u0441\u043b\u0435|\u0432\u043c\u0435\u0441\u0442\u043e", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e\u0431\u044b?|\u043a\u0430\u043a"}, {"\u0441", "\u0442\u0435\u043c", "\u0447\u0442\u043e\u0431\u044b?|\u043a\u0430\u043a"}, movableToRight, {"\u043f\u0440\u0435\u0436\u0434\u0435", "\u0447\u0435\u043c"}, {"\u043e\u0442\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0441", "\u0442\u0435\u0445", "\u043f\u043e\u0440", "\u043a\u0430\u043a"}, {"\u0432", "\u0442\u043e", "\u0432\u0440\u0435\u043c\u044f", "\u043a\u0430\u043a"}, {"\u0441", "\u0442\u043e\u0433\u043e", "\u0432\u0440\u0435\u043c\u0435\u043d\u0438", "\u043a\u0430\u043a"}, {"\u0441", "\u0442\u043e\u0439", "\u043f\u043e\u0440\u044b", "\u043a\u0430\u043a"}, {"\u043f\u043e", "\u043c\u0435\u0440\u0435", "\u0442\u043e\u0433\u043e", "\u043a\u0430\u043a"}};
    private static final String[][] easilySplittable = new String[][]{{"\u0440\u0430\u0434\u0438", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e\u0431\u044b?|\u043a\u0430\u043a"}, {"\u0440\u0430\u043d\u044c\u0448\u0435|\u0440\u0430\u043d\u0435\u0435", "\u0447\u0435\u043c"}, {"\u0437\u0430\u0442\u0435\u043c", "\u0447\u0442\u043e\u0431\u044b?"}, {"\u0441", "\u0442\u043e\u0439", "\u0446\u0435\u043b\u044c\u044e", "\u0447\u0442\u043e\u0431\u044b?"}, {"\u0434\u043e", "\u0442\u0435\u0445", "\u043f\u043e\u0440", "\u043a\u0430\u043a|\u043f\u043e\u043a\u0430"}, {"\u0437\u0430", "\u0442\u043e", "\u0447\u0442\u043e"}, {"\u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u044f", "\u0442\u043e\u043c\u0443", "\u0447\u0442\u043e"}, {"\u0432\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435|\u043d\u0430\u0441\u0447[\u0435\u0451]\u0442", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0438\u0437", "-", "\u0437\u0430", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0432\u043e", "\u0438\u043c\u044f", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0437\u0430", "\u0441\u0447[\u0435\u0451]\u0442", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0432", "\u0441\u0438\u043b\u0443|\u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043d\u0430", "\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043f\u043e", "\u043f\u043e\u0432\u043e\u0434\u0443|\u043f\u0440\u0438\u0447\u0438\u043d\u0435", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043f\u043e", "\u0442\u043e\u0439", "\u043f\u0440\u0438\u0447\u0438\u043d\u0435", "\u0447\u0442\u043e"}, {"\u043d\u0430", "\u0442\u043e\u043c", "\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438", "\u0447\u0442\u043e"}, {"\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e", "\u043e\u0442", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043f\u043e\u0434", "\u0432\u0438\u0434\u043e\u043c|\u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u043c", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043f\u043e\u0434", "\u0442\u0435\u043c", "\u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u043c", "\u0447\u0442\u043e"}, {"\u0432", "\u0441\u0432\u044f\u0437\u0438|\u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0438", "\u0441", "\u0442\u0435\u043c", "\u0447\u0442\u043e"}, {"\u043f\u0440\u0438", "\u0432\u0441[\u0435\u0451]\u043c", "\u0442\u043e\u043c", "\u0447\u0442\u043e"}, {"\u043f\u0440\u0438", "\u0443\u0441\u043b\u043e\u0432\u0438\u0438", "\u0447\u0442\u043e|\u0435\u0441\u043b\u0438"}, {"\u0432\u043f\u043b\u043e\u0442\u044c", "\u0434\u043e", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}};
    private static final String[][] doubleComma = new String[][]{{"\u0438\u0441\u0445\u043e\u0434\u044f", "\u0438\u0437", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u0437\u0430", "\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u043c", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}, {"\u043d\u0435\u0432\u0437\u0438\u0440\u0430\u044f", "\u043d\u0430", "\u0442\u043e", "\u0447\u0442\u043e"}, {"\u0441\u043c\u043e\u0442\u0440\u044f|\u0441\u0443\u0434\u044f", "\u043f\u043e", "\u0442\u043e\u043c\u0443", "\u0447\u0442\u043e"}, {"\u0432\u043e\u043f\u0440\u0435\u043a\u0438", "\u0442\u043e\u043c\u0443", "\u0447\u0442\u043e"}, {"\u043a\u0440\u043e\u043c\u0435|\u043f\u043e\u043c\u0438\u043c\u043e", "\u0442\u043e\u0433\u043e", "\u0447\u0442\u043e"}};
    private static final String[][] nonSplittable = new String[][]{{"\u043c\u0435\u0436\u0434\u0443|\u043c\u0435\u0436", "\u0442\u0435\u043c", "\u043a\u0430\u043a"}, {"\u0442\u0435\u043c", "\u0431\u043e\u043b\u0435\u0435", "\u0447\u0442\u043e"}, {"\u0442\u043e\u0433\u0434\u0430|\u0441\u043b\u043e\u0432\u043d\u043e|\u043f\u043e\u0442\u043e\u043c\u0443", "\u043a\u0430\u043a"}};
    private static final String CONJ_MAIN = "ConjMain";
    private static final String CONJ_LAST = "ConjLast";
    private static final NodePattern clauseBound = NodePattern.N.inPhrase(RussianTreePatterns.clause.markAs("Clause1")).andNot(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("ConjMain"))).and(NodePattern.markedNodeMatches("ConjLast", NodePattern.N.inPhrase(RussianTreePatterns.clause.markAs("Clause2")))).and(NodePattern.markedNodeMatches("Clause1", NodePattern.not(NodePattern.N.alreadyMarkedAs("Clause2"))));
    private static final NodePattern introductorySplitAfter = NodePattern.or(NodePattern.N.inPhrase(NodePattern.custom(n -> IntroductoryConstructions.analyze(n).stream().anyMatch(l -> l.obligatory))).andNot(NodePattern.PUNCT), NodePattern.N.inFormSequence(1, "\u0434\u043e\u043b\u0436\u043d\u043e", "\u0431\u044b\u0442\u044c"));
    private static final NodePattern splittingRequired = NodePattern.or(NodePattern.N.form("\u043d\u0435").message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u044f?"), RussianTreePatterns.emphasis.message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0438\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430?"), NodePattern.N.pos("ADV").directlyBeforeHead().message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0440\u0435\u0447\u0438\u044f?"), NodePattern.N.pos("PARTICLE").noPos("CONJ").message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u044b?"), CommonPatterns.comma.directlyAfter(introductorySplitAfter).message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430?"), NodePattern.not(NodePattern.PUNCT).and(clauseBound).andNot(CommonPatterns.firstWord.pos("CONJ")).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.inFormSequence(0, nesmotryaNaToChto), NodePattern.N.inFormSequence(0, movableToRight)))).message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432 \u0441\u043b\u043e\u0436\u043d\u043e\u043c \u0441\u043e\u044e\u0437\u0435?")).andNot(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, ransheChemCherez).withDependent("obl|advcl", relativeMeasurement)));

    ComplexConjunctions() {
    }

    static NodePattern pattern() {
        return NodePattern.or(ComplexConjunctions.excessiveCommaAfterConj(), ComplexConjunctions.excessiveCommaInside(), ComplexConjunctions.missingCommaInside(), ComplexConjunctions.missingCommaBeforeChem(), ComplexConjunctions.missingCommaBeforeNesmotryaNaToChto());
    }

    private static NodePattern excessiveCommaAfterConj() {
        return PunctuationRules.unmandatedComma.directlyAfter(NodePattern.or((NodePattern[])ComplexConjunctions.allComplexConjunctions().map(words -> NodePattern.N.inFormSequence(((String[])words).length - 1, (String)words)).toArray(NodePattern[]::new)).andNot(NodePattern.N.inFormSequence(1, movableToRight).withNeighbor(-2, NodePattern.not(CommonPatterns.comma).andNot(NodePattern.PUNCT))).andNot(NodePattern.N.inFormSequence(1, "\u0442\u0430\u043a", "\u0447\u0442\u043e").inPhrase(CommonPatterns.withQuestionMark))).reportEverythingTouched().message("\u0417\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u043e\u0441\u043b\u0435 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u0441\u043e\u044e\u0437\u0430 \u043d\u0435 \u043d\u0443\u0436\u043d\u0430").correct(NodeCorrector.replace(""));
    }

    static StreamEx<String[]> allComplexConjunctions() {
        return StreamEx.of((Object[])conditionallySplittable).append((Object[])easilySplittable).append((Object[])nonSplittable).append((Object[])doubleComma);
    }

    private static NodePattern excessiveCommaInside() {
        StreamEx conditional = StreamEx.of((Object[])conditionallySplittable).map(words -> ComplexConjunctions.withComma(words).directlyAfter(NodePattern.N.markAs(CONJ_MAIN)).directlyBefore(NodePattern.N.markAs(CONJ_LAST)).andNot(NodePattern.N.withNeighbor(-((String[])words).length, NodePattern.or(splittingRequired, NodePattern.N.pos("CONJ")))));
        StreamEx unconditional = StreamEx.of((Object[])nonSplittable).map(words -> ComplexConjunctions.withComma(words));
        return NodePattern.or((NodePattern[])Stream.concat(conditional, unconditional).toArray(NodePattern[]::new)).reportEverythingTouched().directlyAfter(NodePattern.or(NodePattern.N.beforeHead().withHead("obl|mark|nmod", NodePattern.not(NodePattern.N.withHeadRelation("ccomp")).noDependents("parataxis", NodePattern.N.beforeHead())).noDependents("parataxis", NodePattern.N.beforeHead()), NodePattern.N.form("\u0442\u043e\u0433\u0434\u0430").withHead("advmod", NodePattern.ROOT).withNeighbor(2, NodePattern.N.form("\u043a\u0430\u043a").withHead("mark", NodePattern.ROOT)), NodePattern.N.afterHead().withHead("fixed", NodePattern.N.beforeHead().withHeadRelation("cc|advmod|mark")), NodePattern.ROOT.noDependents("parataxis", NodePattern.custom(n -> !IntroductoryConstructions.analyze(n).isEmpty()))).andNot(NodePattern.N.directlyAfter(CommonPatterns.comma.after(introductorySplitAfter))).noDependents("conj").noHeadRelation("conj")).message("\u041b\u0438\u0448\u043d\u044f\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0433\u043e \u0441\u043e\u044e\u0437\u0430?").correct(NodeCorrector.replace(""));
    }

    static NodePattern withComma(String[] words) {
        int last = words.length - 1;
        return NodePattern.N.inFormSequence(last, (String[])((StreamEx)StreamEx.of((Object[])words).limit((long)last)).append((Object)",").append((Object)words[last]).toArray(String[]::new));
    }

    private static NodePattern missingCommaInside() {
        return NodePattern.or((NodePattern[])StreamEx.of((Object[])conditionallySplittable).append((Object[])easilySplittable).append((Object[])doubleComma).map(words -> NodePattern.N.inFormSequence(((String[])words).length - 2, (String)words).markAs(CONJ_MAIN).directlyBefore(NodePattern.N.markAs(CONJ_LAST)).reportEverythingTouched().withNeighbor(-((String[])words).length + 1, splittingRequired)).toArray(NodePattern[]::new)).andNot(NodePattern.N.inFormSequence(0, movableToRight).withNeighbor(2, NodePattern.PUNCT)).correct(NodeCorrector.insertAfter(","));
    }

    private static NodePattern missingCommaBeforeChem() {
        return NodePattern.N.form("\u0447\u0435\u043c").markAs("Chem").includeIntoReport().andNot(NodePattern.N.withHead(relativeMeasurement).inFormSequence(1, ransheChemCherez)).directlyAfter(NodePattern.N.pos("ADJ:Comp").noDependents("advmod", NodePattern.N.form("\u043d\u0435"))).withHead("mark", NodePattern.N.withDependent("case", NodePattern.N.after("Chem")).andNot(relativeMeasurement)).message("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0437\u0430\u043f\u044f\u0442\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u00ab\u0447\u0435\u043c\u00bb?").correct(NodeCorrector.insertAfterPrevious(","));
    }

    private static NodePattern missingCommaBeforeNesmotryaNaToChto() {
        return NodePattern.N.inFormSequence(0, nesmotryaNaToChto).andNot(CommonPatterns.firstWord).andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).message("\u041f\u0435\u0440\u0435\u0434 \u0441\u043e\u044e\u0437\u043e\u043c \u00ab\u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f \u043d\u0430 \u0442\u043e \u0447\u0442\u043e\u00bb \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u0437\u0430\u043f\u044f\u0442\u0430\u044f").correct(NodeCorrector.insertAfterPrevious(","));
    }
}

