/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
        this.canUpdate = false;
    }

    @Override
    final boolean openContainer(ContainerKey containerKey) throws StandardException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = null;
            this.containerPath = this.dataFactory.getContainerPath(containerKey, false);
            try {
                inputStream = this.containerPath.getInputStream();
            }
            catch (IOException iOException) {
                this.containerPath = this.dataFactory.getContainerPath(containerKey, true);
                try {
                    inputStream = this.getInputStream();
                }
                catch (IOException iOException2) {
                    this.containerPath = null;
                    boolean bl = false;
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            filterInputStream = new DataInputStream(inputStream);
            this.readHeader(this.getEmbryonicPage((DataInput)((Object)filterInputStream)));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity().toString(), "open", containerKey.toString()});
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    void closeContainer() {
        this.containerPath = null;
    }

    @Override
    public final void clean(boolean bl) throws StandardException {
    }

    @Override
    protected final int preAllocate(long l, int n) {
        return 0;
    }

    @Override
    protected void truncatePages(long l) {
    }

    @Override
    void createContainer(ContainerKey containerKey) throws StandardException {
    }

    @Override
    protected final void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
    }

    @Override
    protected final void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        this.readPositionedPage(l2, byArray);
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long l, byte[] byArray) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            InputStreamUtil.skipFully(inputStream, l);
            InputStreamUtil.readFully(inputStream, byArray, 0, this.pageSize);
            inputStream.close();
            inputStream = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected final void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
    }

    @Override
    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    @Override
    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException((String)"XSAI3.S", (Object[])new Object[0]);
    }

    @Override
    protected void encryptOrDecryptContainer(BaseContainerHandle baseContainerHandle, String string, boolean bl) throws StandardException {
        throw StandardException.newException((String)"XSAI3.S", (Object[])new Object[0]);
    }
}

