/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0003\u0006\u00053!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"\u0002$\u0001\t\u00039\u0005bB'\u0001\u0005\u0004%IA\u0014\u0005\u00075\u0002\u0001\u000b\u0011B(\t\u000bm\u0003A\u0011\u0001/\t\u000b\u001d\u0004A\u0011\u00015\u0003%\t\u000bGo\u00195D_6l\u0017\u000e\u001e+sC\u000e\\WM\u001d\u0006\u0003\u00171\tQa\u001d;bi\u0016T!!\u0004\b\u0002\u0013M$(/Z1nS:<'BA\b\u0011\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0013\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0013#\u0005\u001daunZ4j]\u001e\fQA];o\u0013\u0012\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0003V+&#\u0015a\u00022bi\u000eD\u0017\n\u001a\t\u00037EJ!A\r\u000f\u0003\t1{gnZ\u0001\u000fKb\u0004Xm\u0019;fIN#xN]3t!\u0011)D\bM \u000f\u0005YR\u0004CA\u001c\u001d\u001b\u0005A$BA\u001d\u0019\u0003\u0019a$o\\8u}%\u00111\bH\u0001\u0007!J,G-\u001a4\n\u0005ur$aA'ba*\u00111\b\b\t\u0005kq\u00025\t\u0005\u00026\u0003&\u0011!I\u0010\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005m!\u0015BA#\u001d\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t!S5\n\u0014\t\u0003\u0013\u0002i\u0011A\u0003\u0005\u0006M\u0011\u0001\ra\n\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006g\u0011\u0001\r\u0001N\u0001\u0010G>lW.\u001b;uK\u0012\u001cFo\u001c:fgV\tq\nE\u0002Q+^k\u0011!\u0015\u0006\u0003%N\u000bq!\\;uC\ndWM\u0003\u0002U9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u000b&a\u0002%bg\"\u001cV\r\u001e\t\u00067a\u00034\tQ\u0005\u00033r\u0011a\u0001V;qY\u0016\u001c\u0014\u0001E2p[6LG\u000f^3e'R|'/Z:!\u00031\u0011XmY8sI\u000e{W.\\5u)\ri\u0006-\u001a\t\u00037yK!a\u0018\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006C\u001e\u0001\rAY\u0001\bgR|'/Z%e!\tI5-\u0003\u0002e\u0015\t!2\u000b^1uKN#xN]3Qe>4\u0018\u000eZ3s\u0013\u0012DQAZ\u0004A\u0002\u0001\u000b\u0011b\u001d;pe\u0016t\u0015-\\3\u0002)Y\fG.\u001b3bi\u0016\fE\u000e\\\"p[6LG\u000f^3e)\u0005i\u0006")
public class BatchCommitTracker
implements Logging {
    private final long batchId;
    private final Map<Object, Map<String, Object>> expectedStores;
    private final HashSet<Tuple3<Object, Object, String>> committedStores;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashSet<Tuple3<Object, Object, String>> committedStores() {
        return this.committedStores;
    }

    public void recordCommit(StateStoreProviderId storeId, String storeName) {
        Tuple3 key = new Tuple3((Object)BoxesRunTime.boxToLong((long)storeId.storeId().operatorId()), (Object)BoxesRunTime.boxToInteger((int)storeId.storeId().partitionId()), (Object)storeName);
        this.committedStores().add((Object)key);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Recorded commit for store " + storeId + " with name " + storeName + " for batch " + $this.batchId);
    }

    public void validateAllCommitted() {
        ArrayBuffer missingCommits = new ArrayBuffer();
        this.expectedStores.foreach((Function1 & Serializable)x0$1 -> {
            BatchCommitTracker.$anonfun$validateAllCommitted$1(this, missingCommits, x0$1);
            return BoxedUnit.UNIT;
        });
        if (missingCommits.nonEmpty()) {
            int totalExpected = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.expectedStores.values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)BatchCommitTracker.$anonfun$validateAllCommitted$4(x$10)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            String errorMsg = "Not all StateStores committed for batch " + this.batchId + ". Expected " + totalExpected + " commits but got " + this.committedStores().size() + ". Missing commits: " + missingCommits.mkString(", ");
            this.logError((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw StateStoreErrors$.MODULE$.stateStoreCommitValidationFailed(this.batchId, totalExpected, this.committedStores().size(), missingCommits.mkString(", "));
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "All " + this.committedStores().size() + " StateStores successfully committed for batch " + $this.batchId);
    }

    public static final /* synthetic */ Object $anonfun$validateAllCommitted$3(BatchCommitTracker $this, long operatorId$1, String storeName$2, ArrayBuffer missingCommits$1, int partitionId) {
        Tuple3 key = new Tuple3((Object)BoxesRunTime.boxToLong((long)operatorId$1), (Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)storeName$2);
        if (!$this.committedStores().contains((Object)key)) {
            return missingCommits$1.$plus$eq((Object)("(operator=" + operatorId$1 + ", partition=" + partitionId + ", store=" + storeName$2 + ")"));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateAllCommitted$2(BatchCommitTracker $this, long operatorId$1, ArrayBuffer missingCommits$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String storeName = (String)tuple2._1();
            int numPartitions = tuple2._2$mcI$sp();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach((Function1 & Serializable)partitionId -> BatchCommitTracker.$anonfun$validateAllCommitted$3($this, operatorId$1, storeName, missingCommits$1, BoxesRunTime.unboxToInt((Object)partitionId)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateAllCommitted$1(BatchCommitTracker $this, ArrayBuffer missingCommits$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long operatorId = tuple2._1$mcJ$sp();
            Map storeMap = (Map)tuple2._2();
            storeMap.foreach((Function1 & Serializable)x0$2 -> {
                BatchCommitTracker.$anonfun$validateAllCommitted$2($this, operatorId, missingCommits$1, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$validateAllCommitted$4(Map x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public BatchCommitTracker(UUID runId, long batchId, Map<Object, Map<String, Object>> expectedStores) {
        this.batchId = batchId;
        this.expectedStores = expectedStores;
        Logging.$init$((Logging)this);
        this.committedStores = new HashSet();
    }
}

