/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.DenseRank$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the rank of a value in a group of values. The result is one plus the\n      previously assigned rank value. Unlike the function rank, dense_rank will not produce gaps\n      in the ranking sequence.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\u0010!\u00016B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\r\")Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001#\")!\u000b\u0001C!'\")a\u000b\u0001C)/\"9\u0001\f\u0001b\u0001\n\u0003J\u0006BB1\u0001A\u0003%!\fC\u0004c\u0001\t\u0007I\u0011I2\t\r!\u0004\u0001\u0015!\u0003e\u0011\u001dI\u0007A1A\u0005B)Daa\u001c\u0001!\u0002\u0013Y\u0007\"\u00029\u0001\t\u0003\n\b\"\u0002>\u0001\t#Z\b\"CA\u0002\u0001\u0005\u0005I\u0011AA\u0003\u0011%\tI\u0001AI\u0001\n\u0003\tY\u0001C\u0005\u0002\"\u0001\t\t\u0011\"\u0011\u0002$!I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0003\"CA2\u0001\u0005\u0005I\u0011IA3\u0011%\tI\u0007AA\u0001\n\u0003\nYgB\u0005\u0002\u0016\u0002\n\t\u0011#\u0001\u0002\u0018\u001aAq\u0004IA\u0001\u0012\u0003\tI\n\u0003\u0004N3\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003gK\u0012\u0011!C#\u0003kC\u0011\"a.\u001a\u0003\u0003%\t)!/\t\u0013\u0005u\u0016$!A\u0005\u0002\u0006}\u0006\"CAf3\u0005\u0005I\u0011BAg\u0005%!UM\\:f%\u0006t7N\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0011\u0001aF\r\u001d\u0011\u0005=\u0002T\"\u0001\u0011\n\u0005E\u0002#\u0001\u0003*b].d\u0015n[3\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011(\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!\u0010\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014B\u0001!5\u0003\u001d\u0001\u0018mY6bO\u0016L!AQ\"\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0001#\u0014\u0001C2iS2$'/\u001a8\u0016\u0003\u0019\u00032!O$J\u0013\tA5IA\u0002TKF\u0004\"a\f&\n\u0005-\u0003#AC#yaJ,7o]5p]\u0006I1\r[5mIJ,g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0003\u0006CA\u0018\u0001\u0011\u0015!5\u00011\u0001G)\u0005y\u0015!C<ji\"|%\u000fZ3s)\tyE\u000bC\u0003V\u000b\u0001\u0007a)A\u0003pe\u0012,'/\u0001\u0006sC:\\7k\\;sG\u0016,\u0012!S\u0001\u0012kB$\u0017\r^3FqB\u0014Xm]:j_:\u001cX#\u0001.\u0011\u0007m\u0003\u0017*D\u0001]\u0015\tif,A\u0005j[6,H/\u00192mK*\u0011q\fN\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%]\u0003I)\b\u000fZ1uK\u0016C\bO]3tg&|gn\u001d\u0011\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0003\u0011\u00042a\u00171f!\tyc-\u0003\u0002hA\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003Q\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3tA\u0005i\u0011N\\5uS\u0006dg+\u00197vKN,\u0012a\u001b\t\u00047\u0002d\u0007CA\u0018n\u0013\tq\u0007EA\u0004MSR,'/\u00197\u0002\u001d%t\u0017\u000e^5bYZ\u000bG.^3tA\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003I\u0004\"a]<\u000f\u0005Q,\bCA\u001e5\u0013\t1H'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<5\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002Py\")QP\u0004a\u0001}\u0006Ya.Z<DQ&dGM]3o!\rIt0S\u0005\u0004\u0003\u0003\u0019%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\ry\u0015q\u0001\u0005\b\t>\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0004+\u0007\u0019\u000bya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tY\u0002N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0012\u0001\u00026bm\u0006L1\u0001_A\u0015\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0004E\u00024\u0003sI1!a\u000f5\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t%a\u0012\u0011\u0007M\n\u0019%C\u0002\u0002FQ\u00121!\u00118z\u0011%\tIeEA\u0001\u0002\u0004\t9$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0002b!!\u0015\u0002T\u0005\u0005S\"\u00010\n\u0007\u0005UcL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA.\u0003C\u00022aMA/\u0013\r\ty\u0006\u000e\u0002\b\u0005>|G.Z1o\u0011%\tI%FA\u0001\u0002\u0004\t\t%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0013\u0003OB\u0011\"!\u0013\u0017\u0003\u0003\u0005\r!a\u000e\u0002\r\u0015\fX/\u00197t)\u0011\tY&!\u001c\t\u0013\u0005%s#!AA\u0002\u0005\u0005\u0003f\u0006\u0001\u0002r\u0005]\u0014\u0011PA?\u0003\u007f\n\u0019)!\"\u0002\n\u0006-\u0015qRAI!\ry\u00131O\u0005\u0004\u0003k\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003w\n\u0011\u0011\u0019\u0006!A\u0001\u0002sLR+O\u0007~C\u0013\u0006I\u0017!\u0007>l\u0007/\u001e;fg\u0002\"\b.\u001a\u0011sC:\\\u0007e\u001c4!C\u00022\u0018\r\\;fA%t\u0007%\u0019\u0011he>,\b\u000fI8gAY\fG.^3t]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002zg.\u001a\u0011qYV\u001c\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!aJ,g/[8vg2L\b%Y:tS\u001etW\r\u001a\u0011sC:\\\u0007E^1mk\u0016t\u0003%\u00168mS.,\u0007\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004#/\u00198lY\u0001\"WM\\:f?J\fgn\u001b\u0011xS2d\u0007E\\8uAA\u0014x\u000eZ;dK\u0002:\u0017\r]:\u000bA\u0001\u0002\u0003\u0005\t\u0011j]\u0002\"\b.\u001a\u0011sC:\\\u0017N\\4!g\u0016\fX/\u001a8dK:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!!\u0002\u0003\u000fT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I2iS2$'/\u001a8![\u0001\"\b.[:!SN\u0004Co\u001c\u0011cCN,\u0007\u0005\u001e5fAI\fgn\u001b\u0011p]n\u0002\u0013\rI2iC:<W\rI5oAQDW\r\t<bYV,\u0007e\u001c4!_:,\u0007\u0005\u001e5fA\rD\u0017\u000e\u001c3sK:\u0004s/\u001b7m\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e:jO\u001e,'\u000fI1!G\"\fgnZ3!S:\u0004#/\u00198l]\u0001\"\u0006.[:!SN\u0004\u0013M\u001c\u0011j]R,'O\\1mAA\f'/Y7fi\u0016\u0014\b%\u00198eA]LG\u000e\u001c\u0011cK\u0002\n7o]5h]\u0016$\u0007EY=!i\",'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0003:\fG._:fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qQ\u0001\u0002\u0018*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\r\f\u0011cY\u0001zf)\u0016(D?\"\u0012\u0017\u0006I(W\u000bJ\u0003\u0003\u0006U!S)&#\u0016j\u0014(!\u0005f\u0003\u0013\rI(S\t\u0016\u0013\u0006EQ-!E&\u0002cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-AIJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*Y\u0001Bs%\u0011\u001a(Y\u0001\u001a\u0014\u0006\f\u0011)O\u0005\u000bt\u0005\f\u00112S\u0001\"\u0018M\u0019\u0015bY\u0001\u0012\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0014B\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0019\u0014\"\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QR\u0001\u0006e9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003'\u000bAb^5oI><xLZ;oGN\f\u0011\u0002R3og\u0016\u0014\u0016M\\6\u0011\u0005=J2#B\r\u0002\u001c\u0006\u001d\u0006CBAO\u0003G3u*\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u001b\u0002\u000fI,h\u000e^5nK&!\u0011QUAP\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*!\u0011QVA\u0017\u0003\tIw.C\u0002C\u0003W#\"!a&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\n\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007=\u000bY\fC\u0003E9\u0001\u0007a)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0017q\u0019\t\u0005g\u0005\rg)C\u0002\u0002FR\u0012aa\u00149uS>t\u0007\u0002CAe;\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002PB!\u0011qEAi\u0013\u0011\t\u0019.!\u000b\u0003\r=\u0013'.Z2u\u0001")
public class DenseRank
extends RankLike {
    private final Seq<Expression> children;
    private final Seq<Expression> updateExpressions;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Literal> initialValues;

    public static Option<Seq<Expression>> unapply(DenseRank x$0) {
        return DenseRank$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<DenseRank, A> g) {
        return DenseRank$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, DenseRank> compose(Function1<A$, Seq<Expression>> g) {
        return DenseRank$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public DenseRank withOrder(Seq<Expression> order) {
        return new DenseRank(order);
    }

    @Override
    public Expression rankSource() {
        return package$expressions$.MODULE$.DslExpression(this.rank()).$plus(this.one());
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Literal> initialValues() {
        return this.initialValues;
    }

    @Override
    public String prettyName() {
        return "dense_rank";
    }

    @Override
    public DenseRank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public DenseRank copy(Seq<Expression> children2) {
        return new DenseRank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "DenseRank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DenseRank;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DenseRank)) return false;
        boolean bl = true;
        if (!bl) return false;
        DenseRank denseRank = (DenseRank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = denseRank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!denseRank.canEqual(this)) return false;
        return true;
    }

    public DenseRank(Seq<Expression> children2) {
        this.children = children2;
        If if_ = this.increaseRank();
        this.updateExpressions = (Seq)children2.$plus$colon((Object)if_);
        AttributeReference attributeReference = this.rank();
        this.aggBufferAttributes = (Seq)this.orderAttrs().$plus$colon((Object)attributeReference);
        Literal literal = this.zero();
        this.initialValues = (Seq)this.orderInit().$plus$colon((Object)literal);
    }

    public DenseRank() {
        this((Seq<Expression>)Nil$.MODULE$);
    }
}

