/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.com.google.common.collect.BiMap;
import graphql.com.google.common.collect.HashBiMap;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@Internal
public class Mapping {
    private final Map<Vertex, Vertex> fixedParentRestrictions;
    private final BiMap<Vertex, Vertex> fixedMappings;
    private final List<Vertex> fixedSourceList;
    private final List<Vertex> fixedTargetList;
    private final BiMap<Vertex, Vertex> map;
    private final List<Vertex> sourceList;
    private final List<Vertex> targetList;

    private Mapping(Map<Vertex, Vertex> fixedParentRestrictions, BiMap<Vertex, Vertex> fixedMappings, List<Vertex> fixedSourceList, List<Vertex> fixedTargetList, BiMap<Vertex, Vertex> map, List<Vertex> sourceList, List<Vertex> targetList) {
        this.fixedParentRestrictions = fixedParentRestrictions;
        this.fixedMappings = fixedMappings;
        this.fixedSourceList = fixedSourceList;
        this.fixedTargetList = fixedTargetList;
        this.map = map;
        this.sourceList = sourceList;
        this.targetList = targetList;
    }

    public static Mapping newMapping(Map<Vertex, Vertex> fixedParentRestrictions, BiMap<Vertex, Vertex> fixedMappings, List<Vertex> fixedSourceList, List<Vertex> fixedTargetList) {
        return new Mapping(fixedParentRestrictions, fixedMappings, fixedSourceList, fixedTargetList, HashBiMap.create(), Collections.emptyList(), Collections.emptyList());
    }

    public boolean hasParentRestriction(Vertex v) {
        return this.fixedParentRestrictions.containsKey(v);
    }

    public Vertex getParentRestriction(Vertex v) {
        return this.fixedParentRestrictions.get(v);
    }

    public Vertex getSource(Vertex target) {
        if (this.fixedMappings.containsValue(target)) {
            return (Vertex)this.fixedMappings.inverse().get(target);
        }
        return (Vertex)this.map.inverse().get(target);
    }

    public Vertex getTarget(Vertex source) {
        if (this.fixedMappings.containsKey(source)) {
            return (Vertex)this.fixedMappings.get(source);
        }
        return (Vertex)this.map.get(source);
    }

    public Vertex getSource(int i) {
        if (i < this.fixedSourceList.size()) {
            return this.fixedSourceList.get(i);
        }
        return this.sourceList.get(i - this.fixedSourceList.size());
    }

    public Vertex getTarget(int i) {
        if (i < this.fixedTargetList.size()) {
            return this.fixedTargetList.get(i);
        }
        return this.targetList.get(i - this.fixedTargetList.size());
    }

    public boolean containsSource(Vertex sourceVertex) {
        if (this.fixedMappings.containsKey(sourceVertex)) {
            return true;
        }
        return this.map.containsKey(sourceVertex);
    }

    public boolean containsTarget(Vertex targetVertex) {
        if (this.fixedMappings.containsValue(targetVertex)) {
            return true;
        }
        return this.map.containsValue(targetVertex);
    }

    public boolean contains(Vertex vertex, boolean sourceOrTarget) {
        return sourceOrTarget ? this.containsSource(vertex) : this.containsTarget(vertex);
    }

    public int size() {
        return this.fixedMappings.size() + this.map.size();
    }

    public int fixedSize() {
        return this.fixedMappings.size();
    }

    public int nonFixedSize() {
        return this.map.size();
    }

    public void add(Vertex source, Vertex target) {
        this.map.put(source, target);
        this.sourceList.add(source);
        this.targetList.add(target);
    }

    public Mapping copyMappingWithLastElementRemoved() {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        newMap.remove(this.sourceList.get(this.sourceList.size() - 1));
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList.subList(0, this.sourceList.size() - 1));
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList.subList(0, this.targetList.size() - 1));
        return new Mapping(this.fixedParentRestrictions, this.fixedMappings, this.fixedSourceList, this.fixedTargetList, newMap, newSourceList, newTargetList);
    }

    public Mapping copy() {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList);
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList);
        return new Mapping(this.fixedParentRestrictions, this.fixedMappings, this.fixedSourceList, this.fixedTargetList, newMap, newSourceList, newTargetList);
    }

    public Mapping extendMapping(Vertex source, Vertex target) {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        newMap.put(source, target);
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList);
        newSourceList.add(source);
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList);
        newTargetList.add(target);
        return new Mapping(this.fixedParentRestrictions, this.fixedMappings, this.fixedSourceList, this.fixedTargetList, newMap, newSourceList, newTargetList);
    }

    public void forEachTarget(Consumer<? super Vertex> action) {
        for (Vertex t : this.fixedTargetList) {
            action.accept(t);
        }
        for (Vertex t : this.targetList) {
            action.accept(t);
        }
    }

    public void forEachNonFixedTarget(Consumer<? super Vertex> action) {
        for (Vertex t : this.targetList) {
            action.accept(t);
        }
    }

    public void forEachNonFixedSourceAndTarget(BiConsumer<? super Vertex, ? super Vertex> consumer) {
        this.map.forEach(consumer);
    }

    public Mapping invert() {
        HashBiMap<Vertex, Vertex> invertedFixedMappings = HashBiMap.create();
        for (Vertex s : this.fixedMappings.keySet()) {
            Vertex t = (Vertex)this.fixedMappings.get(s);
            invertedFixedMappings.put(t, s);
        }
        HashBiMap<Vertex, Vertex> invertedMap = HashBiMap.create();
        for (Vertex s : this.map.keySet()) {
            Vertex t = (Vertex)this.map.get(s);
            invertedMap.put(t, s);
        }
        return new Mapping(this.fixedParentRestrictions, invertedFixedMappings, this.fixedTargetList, this.fixedSourceList, invertedMap, this.targetList, this.sourceList);
    }
}

