/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.healthcheck;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.oap.server.library.util.HealthChecker;

public class DelegatedHealthChecker
implements HealthChecker {
    private final AtomicReference<HealthChecker> delegated = new AtomicReference();

    public void health() {
        Optional.ofNullable(this.delegated.get()).ifPresent(HealthChecker::health);
    }

    public void unHealth(Throwable t) {
        Optional.ofNullable(this.delegated.get()).ifPresent(d -> d.unHealth(t));
    }

    public void unHealth(String reason) {
        Optional.ofNullable(this.delegated.get()).ifPresent(d -> d.unHealth(reason));
    }

    public void register(HealthChecker healthChecker) {
        this.delegated.set(healthChecker);
    }
}

