/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBPprofDataQueryDAO
extends AbstractBanyanDBDAO
implements IPprofDataQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"task_id", (Object)"instance_id", (Object)"upload_time", (Object)"data_binary");

    public BanyanDBPprofDataQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<PprofProfilingDataRecord> getByTaskIdAndInstances(final String taskId, final List<String> instanceIds) throws IOException {
        if (StringUtil.isBlank((String)taskId)) {
            return new ArrayList<PprofProfilingDataRecord>();
        }
        StreamQueryResponse resp = this.query(false, "pprof_profiling_data", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("task_id", taskId));
                if (CollectionUtils.isNotEmpty((List)instanceIds)) {
                    query.and(this.in("instance_id", instanceIds));
                }
            }
        });
        ArrayList<PprofProfilingDataRecord> records = new ArrayList<PprofProfilingDataRecord>(resp.size());
        for (RowEntity entity : resp.getElements()) {
            records.add(this.buildProfilingDataRecord(entity));
        }
        return records;
    }

    private PprofProfilingDataRecord buildProfilingDataRecord(RowEntity entity) {
        PprofProfilingDataRecord.Builder builder = new PprofProfilingDataRecord.Builder();
        BanyanDBConverter.StorageToStream storageToStream = new BanyanDBConverter.StorageToStream("pprof_profiling_data", entity);
        return builder.storage2Entity((Convert2Entity)storageToStream);
    }
}

