/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.exception;

import io.grpc.Status;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.AbortedException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.AlreadyExistsException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.CancelledException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.DataLossException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.DeadlineExceededException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.FailedPreconditionException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InternalException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidArgumentException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.NotFoundException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.OutOfRangeException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.PermissionDeniedException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.ResourceExhaustedException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.UnauthenticatedException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.UnavailableException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.UnimplementedException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.UnknownException;

class BanyanDBApiExceptionFactory {
    private BanyanDBApiExceptionFactory() {
    }

    public static BanyanDBException createException(Throwable cause, Status.Code statusCode, boolean retryable) {
        switch (statusCode) {
            case CANCELLED: {
                return new CancelledException(cause, statusCode, retryable);
            }
            case NOT_FOUND: {
                return new NotFoundException(cause, statusCode, retryable);
            }
            case INVALID_ARGUMENT: {
                return new InvalidArgumentException(cause, statusCode, retryable);
            }
            case DEADLINE_EXCEEDED: {
                return new DeadlineExceededException(cause, statusCode, retryable);
            }
            case ALREADY_EXISTS: {
                return new AlreadyExistsException(cause, statusCode, retryable);
            }
            case PERMISSION_DENIED: {
                return new PermissionDeniedException(cause, statusCode, retryable);
            }
            case RESOURCE_EXHAUSTED: {
                return new ResourceExhaustedException(cause, statusCode, retryable);
            }
            case FAILED_PRECONDITION: {
                return new FailedPreconditionException(cause, statusCode, retryable);
            }
            case ABORTED: {
                return new AbortedException(cause, statusCode, retryable);
            }
            case OUT_OF_RANGE: {
                return new OutOfRangeException(cause, statusCode, retryable);
            }
            case UNIMPLEMENTED: {
                return new UnimplementedException(cause, statusCode, retryable);
            }
            case INTERNAL: {
                return new InternalException(cause, statusCode, retryable);
            }
            case UNAVAILABLE: {
                return new UnavailableException(cause, statusCode, retryable);
            }
            case DATA_LOSS: {
                return new DataLossException(cause, statusCode, retryable);
            }
            case UNAUTHENTICATED: {
                return new UnauthenticatedException(cause, statusCode, retryable);
            }
        }
        return new UnknownException(cause, statusCode, retryable);
    }
}

