/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc;

import com.google.common.collect.Sets;
import io.grpc.Status;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBGrpcApiExceptionFactory;

public class HandleExceptionsWith {
    private static final BanyanDBGrpcApiExceptionFactory EXCEPTION_FACTORY = new BanyanDBGrpcApiExceptionFactory(Sets.newHashSet((Object[])new Status.Code[]{Status.Code.UNAVAILABLE, Status.Code.DEADLINE_EXCEEDED}));

    private HandleExceptionsWith() {
    }

    public static <RESP, E extends BanyanDBException> RESP callAndTranslateApiException(SupplierWithIO<RESP, E> respSupplier) throws BanyanDBException {
        try {
            return respSupplier.get();
        }
        catch (Exception exception) {
            throw EXCEPTION_FACTORY.createException(exception);
        }
    }

    @FunctionalInterface
    public static interface SupplierWithIO<T, E extends Throwable> {
        public T get() throws E;
    }
}

