/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCManagementDAO
extends JDBCSQLExecutor
implements IManagementDAO {
    private final JDBCClient jdbcClient;
    private final StorageBuilder<ManagementData> storageBuilder;

    public void insert(Model model, ManagementData storageData) throws IOException {
        try (Connection connection = this.jdbcClient.getConnection();){
            StorageData data = this.getByID(this.jdbcClient, model.getName(), storageData.id().build(), this.storageBuilder);
            if (data != null) {
                return;
            }
            SQLExecutor insertExecutor = this.getInsertExecutor(model, storageData, 0L, this.storageBuilder, (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage(), null);
            insertExecutor.invoke(connection);
        }
        catch (IOException | SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Generated
    public JDBCManagementDAO(JDBCClient jdbcClient, StorageBuilder<ManagementData> storageBuilder) {
        this.jdbcClient = jdbcClient;
        this.storageBuilder = storageBuilder;
    }
}

