/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.engine;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;

public class SwaggerConsumer {
    private Class<?> consumerIntf;
    private final Map<Method, SwaggerConsumerOperation> operations = new HashMap<Method, SwaggerConsumerOperation>();

    public Class<?> getConsumerIntf() {
        return this.consumerIntf;
    }

    public void setConsumerIntf(Class<?> consumerIntf) {
        this.consumerIntf = consumerIntf;
    }

    public void addOperation(SwaggerConsumerOperation op) {
        this.operations.put(op.getConsumerMethod(), op);
    }

    @VisibleForTesting
    public SwaggerConsumerOperation findOperation(String consumerMethodName) {
        for (Map.Entry<Method, SwaggerConsumerOperation> operationEntry : this.operations.entrySet()) {
            if (!operationEntry.getKey().getName().equals(consumerMethodName)) continue;
            return operationEntry.getValue();
        }
        return null;
    }

    public SwaggerConsumerOperation findOperation(Method consumerMethod) {
        return this.operations.get(consumerMethod);
    }

    public Map<Method, SwaggerConsumerOperation> getOperations() {
        return this.operations;
    }
}

