/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuf;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamPacketHeader;
import org.apache.ratis.protocol.DataStreamReplyHeader;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.thirdparty.io.netty.channel.DefaultFileRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyDataStreamUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NettyDataStreamUtils.class);

    public static RaftProtos.DataStreamPacketHeaderProto.Option getOption(WriteOption option) {
        if (option == StandardWriteOption.FLUSH) {
            return null;
        }
        if (option instanceof StandardWriteOption) {
            return RaftProtos.DataStreamPacketHeaderProto.Option.forNumber((int)((StandardWriteOption)option).ordinal());
        }
        throw new IllegalArgumentException("Unexpected WriteOption " + option);
    }

    public static ByteBuffer getDataStreamRequestHeaderProtoByteBuffer(DataStreamRequest request) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(request.getClientId().toByteString()).setStreamId(request.getStreamId()).setStreamOffset(request.getStreamOffset()).setType(request.getType()).setDataLength(request.getDataLength());
        request.getWriteOptionList().stream().map(NettyDataStreamUtils::getOption).filter(Objects::nonNull).forEach(arg_0 -> ((RaftProtos.DataStreamPacketHeaderProto.Builder)b).addOptions(arg_0));
        return RaftProtos.DataStreamRequestHeaderProto.newBuilder().setPacketHeader(b).build().toByteString().asReadOnlyByteBuffer();
    }

    public static ByteBuffer getDataStreamReplyHeaderProtoByteBuf(DataStreamReplyByteBuffer reply) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(reply.getClientId().toByteString()).setStreamId(reply.getStreamId()).setStreamOffset(reply.getStreamOffset()).setType(reply.getType()).setDataLength(reply.getDataLength());
        return RaftProtos.DataStreamReplyHeaderProto.newBuilder().setPacketHeader(b).setBytesWritten(reply.getBytesWritten()).setSuccess(reply.isSuccess()).addAllCommitInfos((Iterable)reply.getCommitInfos()).build().toByteString().asReadOnlyByteBuffer();
    }

    public static void encodeDataStreamRequestHeader(DataStreamRequest request, Consumer<Object> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamRequestHeaderProtoByteBuffer(request);
        ByteBuf headerBodyLenBuf = allocator.ioBuffer(DataStreamPacketHeader.getSizeOfHeaderBodyLen());
        headerBodyLenBuf.writeLong((long)headerBuf.remaining() + request.getDataLength());
        out.accept(headerBodyLenBuf);
        ByteBuf headerLenBuf = allocator.ioBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)headerBuf));
    }

    public static void encodeDataStreamRequestByteBuffer(DataStreamRequestByteBuffer request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader((DataStreamRequest)request, out, allocator);
        NettyDataStreamUtils.encodeByteBuffer(request.slice(), out);
    }

    public static void encodeByteBuffer(ByteBuffer buffer, Consumer<Object> out) {
        if (buffer.remaining() == 0) {
            out.accept(Unpooled.EMPTY_BUFFER);
            return;
        }
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)buffer));
    }

    public static void encodeDataStreamRequestByteBuf(DataStreamRequestByteBuf request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader((DataStreamRequest)request, out, allocator);
        NettyDataStreamUtils.encodeByteBuf(request.slice(), out);
    }

    public static void encodeByteBuf(ByteBuf buffer, Consumer<Object> out) {
        if (buffer.readableBytes() == 0) {
            out.accept(Unpooled.EMPTY_BUFFER);
            return;
        }
        out.accept(buffer);
    }

    public static void encodeDataStreamRequestFilePositionCount(DataStreamRequestFilePositionCount request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader((DataStreamRequest)request, out, allocator);
        FilePositionCount f = request.getFile();
        out.accept(new DefaultFileRegion(f.getFile(), f.getPosition(), f.getCount()));
    }

    public static void encodeDataStreamReplyByteBuffer(DataStreamReplyByteBuffer reply, Consumer<ByteBuf> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamReplyHeaderProtoByteBuf(reply);
        ByteBuf headerLenBuf = allocator.ioBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)headerBuf));
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)reply.slice()));
    }

    public static DataStreamRequestByteBuf decodeDataStreamRequestByteBuf(ByteBuf buf) {
        return Optional.ofNullable(NettyDataStreamUtils.decodeDataStreamRequestHeader(buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> new DataStreamRequestByteBuf(header, NettyDataStreamUtils.decodeData(buf, (DataStreamPacketHeader)header, ByteBuf::retain))).orElse(null);
    }

    public static DataStreamRequestHeader decodeDataStreamRequestHeader(ByteBuf buf) {
        if (DataStreamPacketHeader.getSizeOfHeaderBodyLen() > buf.readableBytes()) {
            return null;
        }
        long headerBodyBufLen = buf.readLong();
        if (headerBodyBufLen > (long)buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamRequestHeaderProto header = RaftProtos.DataStreamRequestHeaderProto.parseFrom((ByteBuffer)headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h = header.getPacketHeader();
            if (h.getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                WriteOption[] options = new WriteOption[h.getOptionsCount()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = StandardWriteOption.values()[h.getOptions(i).ordinal()];
                }
                return new DataStreamRequestHeader(ClientId.valueOf((ByteString)h.getClientId()), h.getType(), h.getStreamId(), h.getStreamOffset(), h.getDataLength(), options);
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode request header:", (Throwable)e);
            buf.resetReaderIndex();
            return null;
        }
    }

    public static ByteBuffer copy(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static DataStreamReplyByteBuffer decodeDataStreamReplyByteBuffer(ByteBuf buf) {
        return Optional.ofNullable(NettyDataStreamUtils.decodeDataStreamReplyHeader(buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> DataStreamReplyByteBuffer.newBuilder().setDataStreamReplyHeader(header).setBuffer(NettyDataStreamUtils.decodeData(buf, (DataStreamPacketHeader)header, NettyDataStreamUtils::copy)).build()).orElse(null);
    }

    public static DataStreamReplyHeader decodeDataStreamReplyHeader(ByteBuf buf) {
        if (DataStreamPacketHeader.getSizeOfHeaderLen() > buf.readableBytes()) {
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamReplyHeaderProto header = RaftProtos.DataStreamReplyHeaderProto.parseFrom((ByteBuffer)headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h = header.getPacketHeader();
            if (header.getPacketHeader().getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                return new DataStreamReplyHeader(ClientId.valueOf((ByteString)h.getClientId()), h.getType(), h.getStreamId(), h.getStreamOffset(), h.getDataLength(), header.getBytesWritten(), header.getSuccess(), (Collection)header.getCommitInfosList());
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode reply header:", (Throwable)e);
            buf.resetReaderIndex();
            return null;
        }
    }

    public static <HEADER extends DataStreamPacketHeader> HEADER checkHeader(HEADER header, ByteBuf buf) {
        if (header == null) {
            return null;
        }
        if ((long)buf.readableBytes() < header.getDataLength()) {
            buf.resetReaderIndex();
            return null;
        }
        return header;
    }

    public static <DATA> DATA decodeData(ByteBuf buf, DataStreamPacketHeader header, Function<ByteBuf, DATA> toData) {
        DATA data;
        int dataLength = Math.toIntExact(header.getDataLength());
        if (dataLength > 0) {
            data = toData.apply(buf.slice(buf.readerIndex(), dataLength));
            buf.readerIndex(buf.readerIndex() + dataLength);
        } else {
            data = null;
        }
        buf.markReaderIndex();
        return data;
    }
}

