/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.KeyGeneratorUtil;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ork", description={"write range keys with the help of the ozone clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class RangeKeysGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RangeKeysGenerator.class);
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="ockrwvolume")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data."}, defaultValue="ockrwbucket")
    private String bucketName;
    @CommandLine.Option(names={"-r", "--range-each-client-write"}, description={"Write range for each client."}, defaultValue="0")
    private int range;
    @CommandLine.Option(names={"-s", "--key-start-index"}, description={"Start index of key."}, defaultValue="0")
    private int startIndex;
    @CommandLine.Option(names={"-k", "--key-encode"}, description={"The algorithm to generate key names. Options are pureIndex, md5"}, defaultValue="md5")
    private String encodeFormat;
    @CommandLine.Option(names={"-g", "--size"}, description={"Generated object size. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="1B", converter={StorageSizeConverter.class})
    private StorageSize objectSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generate object content."}, defaultValue="1024")
    private int bufferSize;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private KeyGeneratorUtil kg;
    private int clientCount;
    private OzoneClient[] ozoneClients;
    private ContentGenerator contentGenerator;
    private Timer timer;

    @Override
    public Void call() throws Exception {
        int i;
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        this.clientCount = this.getThreadNo();
        this.ozoneClients = new OzoneClient[this.clientCount];
        for (i = 0; i < this.clientCount; ++i) {
            this.ozoneClients[i] = this.createOzoneClient(this.omServiceID, ozoneConfiguration);
        }
        this.ensureVolumeAndBucketExist(this.ozoneClients[0], this.volumeName, this.bucketName);
        this.contentGenerator = new ContentGenerator(this.objectSize.toBytes(), this.bufferSize);
        this.timer = this.getMetrics().timer("key-read-write");
        this.kg = new KeyGeneratorUtil();
        this.runTests(this::generateRangeKeys);
        for (i = 0; i < this.clientCount; ++i) {
            if (this.ozoneClients[i] == null) continue;
            this.ozoneClients[i].close();
        }
        return null;
    }

    public void generateRangeKeys(long count) throws Exception {
        int clientIndex = (int)(count % (long)this.clientCount);
        OzoneClient client = this.ozoneClients[clientIndex];
        int start = this.startIndex + (int)count * this.range;
        int end = start + this.range;
        this.timer.time(() -> {
            switch (this.encodeFormat) {
                case "pureIndex": {
                    this.loopRunner(this.kg.pureIndexKeyNameFunc(), client, start, end);
                    break;
                }
                case "md5": {
                    this.loopRunner(this.kg.md5KeyNameFunc(), client, start, end);
                    break;
                }
                default: {
                    this.loopRunner(this.kg.md5KeyNameFunc(), client, start, end);
                }
            }
            return null;
        });
    }

    public void loopRunner(Function<Integer, String> keyNameGeneratorfunc, OzoneClient client, int start, int end) throws Exception {
        for (int i = start; i < end + 1; ++i) {
            String keyName = this.getPrefix() + "/" + keyNameGeneratorfunc.apply(i);
            try (OzoneOutputStream out = client.getProxy().createKey(this.volumeName, this.bucketName, keyName, this.objectSize.toBytes(), null, new HashMap());){
                this.contentGenerator.write((OutputStream)out);
                continue;
            }
        }
    }
}

