/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.ratis.parse;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.function.Function;
import org.apache.hadoop.ozone.debug.ratis.parse.RatisLogParser;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.tools.ParseRatisLog;
import picocli.CommandLine;

public abstract class BaseLogParser {
    @CommandLine.Option(names={"-s", "--segmentPath", "--segment-path"}, required=true, description={"Path of the segment file"})
    private File segmentFile;

    public void parseRatisLogs(Function<RaftProtos.StateMachineLogEntryProto, String> smLogToStr) {
        try {
            ParseRatisLog.Builder builder = new ParseRatisLog.Builder();
            builder.setSegmentFile(this.segmentFile);
            builder.setSMLogToString(smLogToStr);
            ParseRatisLog prl = builder.build();
            prl.dumpSegmentFile();
        }
        catch (Exception e) {
            System.out.println(RatisLogParser.class.getSimpleName() + "failed with exception  " + e);
        }
    }

    @VisibleForTesting
    public void setSegmentFile(File segmentFile) {
        this.segmentFile = segmentFile;
    }
}

