/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks.updater;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdater;
import org.apache.ozone.recon.schema.generated.tables.daos.ReconTaskStatusDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.ReconTaskStatus;

@Singleton
public class ReconTaskStatusUpdaterManager {
    private final ReconTaskStatusDao reconTaskStatusDao;
    private final Map<String, ReconTaskStatusUpdater> updaterCache;

    @Inject
    public ReconTaskStatusUpdaterManager(ReconTaskStatusDao reconTaskStatusDao) {
        this.reconTaskStatusDao = reconTaskStatusDao;
        this.updaterCache = new ConcurrentHashMap<String, ReconTaskStatusUpdater>();
        List tasks = reconTaskStatusDao.findAll();
        for (ReconTaskStatus task : tasks) {
            this.updaterCache.put(task.getTaskName(), new ReconTaskStatusUpdater(reconTaskStatusDao, task));
        }
    }

    public ReconTaskStatusUpdater getTaskStatusUpdater(String taskName) {
        return this.updaterCache.computeIfAbsent(taskName, name -> new ReconTaskStatusUpdater(this.reconTaskStatusDao, (String)name));
    }
}

