/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.ozone.container.checksum.ContainerMerkleTreeWriter;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScanError;
import org.apache.hadoop.ozone.container.ozoneimpl.MetadataScanResult;

public final class DataScanResult
extends MetadataScanResult {
    private final ContainerMerkleTreeWriter dataTree;
    private static final DataScanResult DELETED = new DataScanResult(Collections.emptyList(), new ContainerMerkleTreeWriter(), true);

    private DataScanResult(List<ContainerScanError> errors, ContainerMerkleTreeWriter dataTree, boolean deleted) {
        super(errors, deleted);
        this.dataTree = dataTree;
    }

    public static DataScanResult unhealthyMetadata(MetadataScanResult result) {
        Preconditions.checkArgument((boolean)result.hasErrors());
        return new DataScanResult(result.getErrors(), new ContainerMerkleTreeWriter(), false);
    }

    public static DataScanResult deleted() {
        return DELETED;
    }

    public static DataScanResult fromErrors(List<ContainerScanError> errors, ContainerMerkleTreeWriter dataTree) {
        return new DataScanResult(errors, dataTree, false);
    }

    public ContainerMerkleTreeWriter getDataTree() {
        return this.dataTree;
    }
}

