/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ScanResult;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractContainerScannerMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScannerConfiguration;
import org.apache.hadoop.ozone.container.ozoneimpl.DataScanResult;
import org.apache.hadoop.ozone.container.ozoneimpl.MetadataScanResult;
import org.slf4j.Logger;

public final class ContainerScanHelper {
    private final Logger log;
    private final ContainerController controller;
    private final AbstractContainerScannerMetrics metrics;
    private final long minScanGap;

    public static ContainerScanHelper withoutScanGap(Logger log, ContainerController controller, AbstractContainerScannerMetrics metrics) {
        return new ContainerScanHelper(log, controller, metrics, 0L);
    }

    public static ContainerScanHelper withScanGap(Logger log, ContainerController controller, AbstractContainerScannerMetrics metrics, ContainerScannerConfiguration conf) {
        return new ContainerScanHelper(log, controller, metrics, conf.getContainerScanMinGap());
    }

    private ContainerScanHelper(Logger log, ContainerController controller, AbstractContainerScannerMetrics metrics, long minScanGap) {
        this.log = log;
        this.controller = controller;
        this.metrics = metrics;
        this.minScanGap = minScanGap;
    }

    public void scanData(Container<?> container, DataTransferThrottler throttler, Canceler canceler) throws IOException, InterruptedException {
        if (!this.shouldScanData(container)) {
            return;
        }
        Object containerData = container.getContainerData();
        long containerId = ((ContainerData)containerData).getContainerID();
        this.logScanStart((ContainerData)containerData, "data");
        DataScanResult result = container.scanData(throttler, canceler);
        if (result.isDeleted()) {
            this.log.debug("Container [{}] has been deleted during the data scan.", (Object)containerId);
        } else {
            try {
                this.controller.updateContainerChecksum(containerId, result.getDataTree());
            }
            catch (IOException ex) {
                this.log.warn("Failed to update container checksum after scan of container {}", (Object)containerId, (Object)ex);
            }
            if (result.hasErrors()) {
                this.handleUnhealthyScanResult((ContainerData)containerData, result);
            }
            this.metrics.incNumContainersScanned();
        }
        Instant now = Instant.now();
        if (!result.isDeleted()) {
            this.controller.updateDataScanTimestamp(containerId, now);
        }
        this.logScanCompleted((ContainerData)containerData, now);
    }

    public void scanMetadata(Container<?> container) throws IOException, InterruptedException {
        if (!this.shouldScanMetadata(container)) {
            return;
        }
        Object containerData = container.getContainerData();
        long containerId = ((ContainerData)containerData).getContainerID();
        this.logScanStart((ContainerData)containerData, "only metadata");
        MetadataScanResult result = container.scanMetaData();
        if (result.isDeleted()) {
            this.log.debug("Container [{}] has been deleted during metadata scan.", (Object)containerId);
            return;
        }
        if (result.hasErrors()) {
            this.handleUnhealthyScanResult((ContainerData)containerData, result);
        }
        Instant now = Instant.now();
        this.metrics.incNumContainersScanned();
        this.logScanCompleted((ContainerData)containerData, now);
    }

    public void handleUnhealthyScanResult(ContainerData containerData, ScanResult result) throws IOException {
        boolean containerMarkedUnhealthy;
        long containerID = containerData.getContainerID();
        this.log.error("Corruption detected in container [{}]. Marking it UNHEALTHY. {}", (Object)containerID, (Object)result);
        if (this.log.isDebugEnabled()) {
            StringBuilder allErrorString = new StringBuilder();
            result.getErrors().forEach(r -> allErrorString.append(r).append('\n'));
            this.log.debug("Complete list of errors detected while scanning container {}:\n{}", (Object)containerID, (Object)allErrorString);
        }
        if (containerMarkedUnhealthy = this.controller.markContainerUnhealthy(containerID, result)) {
            this.metrics.incNumUnHealthyContainers();
            this.triggerVolumeScan(containerData);
        }
    }

    public void triggerVolumeScan(ContainerData containerData) {
        HddsVolume volume = containerData.getVolume();
        if (volume != null && !volume.isFailed()) {
            this.log.info("Triggering scan of volume [{}] with unhealthy container [{}]", (Object)volume, (Object)containerData.getContainerID());
            StorageVolumeUtil.onFailure(volume);
        } else if (volume == null) {
            this.log.warn("Cannot trigger volume scan for container {} since its volume is null", (Object)containerData.getContainerID());
        } else {
            this.log.debug("Skipping volume scan for container {} since its volume {} has failed.", (Object)containerData.getContainerID(), (Object)volume);
        }
    }

    public boolean shouldScanMetadata(Container<?> container) {
        if (container == null) {
            return false;
        }
        long containerID = ((ContainerData)container.getContainerData()).getContainerID();
        HddsVolume containerVolume = ((ContainerData)container.getContainerData()).getVolume();
        if (containerVolume.isFailed()) {
            this.log.debug("Skipping scan for container {} since its volume {} has failed.", (Object)containerID, (Object)containerVolume);
            return false;
        }
        return !this.recentlyScanned((ContainerData)container.getContainerData());
    }

    public boolean shouldScanData(Container<?> container) {
        return this.shouldScanMetadata(container) && container.shouldScanData();
    }

    private boolean recentlyScanned(ContainerData containerData) {
        Instant now;
        Optional<Instant> lastScanTime = containerData.lastDataScanTime();
        boolean recentlyScanned = lastScanTime.map(arg_0 -> this.lambda$recentlyScanned$1(now = Instant.now(), arg_0)).orElse(false);
        if (recentlyScanned && this.log.isDebugEnabled()) {
            this.log.debug("Skipping scan for container {} which was last scanned at {}. Current time is {}.", new Object[]{containerData.getContainerID(), lastScanTime.get(), now});
        }
        return recentlyScanned;
    }

    private void logScanStart(ContainerData containerData, String scanType) {
        if (this.log.isDebugEnabled()) {
            Optional<Instant> scanTimestamp = containerData.lastDataScanTime();
            String lastScanTime = scanTimestamp.map(ts -> "at " + ts).orElse("never");
            this.log.debug("Scanning {} of container {}, last scanned {}", new Object[]{scanType, containerData.getContainerID(), lastScanTime});
        }
    }

    private void logScanCompleted(ContainerData containerData, Instant timestamp) {
        this.log.debug("Completed scan of container {} at {}", (Object)containerData.getContainerID(), (Object)timestamp);
    }

    private /* synthetic */ Boolean lambda$recentlyScanned$1(Instant now, Instant scanInstant) {
        return Duration.between(now, scanInstant).abs().compareTo(Duration.ofMillis(this.minScanGap)) < 0;
    }
}

