/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotDeleteResponse;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureState;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureStateAspect;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotDeleteRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMSnapshotDeleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMSnapshotDeleteRequest.class);
    }

    public OMSnapshotDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    @RequireSnapshotFeatureState(value=true)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        RequireSnapshotFeatureStateAspect.aspectOf().checkFeatureState(joinPoint);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.DeleteSnapshotRequest deleteSnapshotRequest = omRequest.getDeleteSnapshotRequest();
        String snapshotName = deleteSnapshotRequest.getSnapshotName();
        OmUtils.validateSnapshotName((String)snapshotName);
        String volumeName = deleteSnapshotRequest.getVolumeName();
        String bucketName = deleteSnapshotRequest.getBucketName();
        ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
        volumeName = resolvedBucket.realVolume();
        bucketName = resolvedBucket.realBucket();
        UserGroupInformation ugi = this.createUGIForApi();
        String bucketOwner = ozoneManager.getBucketOwner(volumeName, bucketName, IAccessAuthorizer.ACLType.READ, OzoneObj.ResourceType.BUCKET);
        if (!ozoneManager.isAdmin(ugi) && !ozoneManager.isOwner(ugi, bucketOwner)) {
            throw new OMException("Only bucket owners and Ozone admins can delete snapshots", OMException.ResultCodes.PERMISSION_DENIED);
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setDeleteSnapshotRequest(OzoneManagerProtocolProtos.DeleteSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setSnapshotName(snapshotName).setDeletionTime(Time.now()));
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        SnapshotInfo snapshotInfo;
        String snapshotName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMClientResponse omClientResponse;
        Exception exception;
        OMMetrics omMetrics;
        block22: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumSnapshotDeletes();
            boolean acquiredBucketLock = false;
            boolean acquiredSnapshotLock = false;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.DeleteSnapshotRequest request = this.getOmRequest().getDeleteSnapshotRequest();
            volumeName = request.getVolumeName();
            bucketName = request.getBucketName();
            snapshotName = request.getSnapshotName();
            long deletionTime = request.getDeletionTime();
            snapshotInfo = null;
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotName}));
                    acquiredSnapshotLock = this.getOmLockDetails().isLockAcquired();
                    String tableKey = SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotName);
                    snapshotInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)tableKey);
                    if (snapshotInfo == null) {
                        throw new OMException("Snapshot does not exist", OMException.ResultCodes.FILE_NOT_FOUND);
                    }
                    switch (snapshotInfo.getSnapshotStatus()) {
                        case SNAPSHOT_DELETED: {
                            throw new OMException("Snapshot is already deleted. Pending reclamation.", OMException.ResultCodes.FILE_NOT_FOUND);
                        }
                        case SNAPSHOT_ACTIVE: {
                            break;
                        }
                        default: {
                            throw new OMException("Snapshot exists but no longer in active state", OMException.ResultCodes.FILE_NOT_FOUND);
                        }
                    }
                    snapshotInfo.setSnapshotStatus(SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED);
                    snapshotInfo.setDeletionTime(deletionTime);
                    omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)tableKey), CacheValue.get((long)context.getIndex(), (Object)snapshotInfo));
                    omResponse.setDeleteSnapshotResponse(OzoneManagerProtocolProtos.DeleteSnapshotResponse.newBuilder());
                    omClientResponse = new OMSnapshotDeleteResponse(omResponse.build(), tableKey, snapshotInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMSnapshotDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredSnapshotLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotName}));
                    }
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (acquiredSnapshotLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotName}));
                }
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredSnapshotLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotName}));
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        if (snapshotInfo == null) {
            snapshotInfo = SnapshotInfo.newInstance((String)volumeName, (String)bucketName, (String)snapshotName, null, (long)Time.now());
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.DELETE_SNAPSHOT, snapshotInfo.toAuditMap(), exception, userInfo));
        String snapshotPath = snapshotInfo.getSnapshotPath();
        if (exception == null) {
            omMetrics.decNumSnapshotActive();
            omMetrics.incNumSnapshotDeleted();
            LOG.info("Deleted snapshot '{}' under path '{}'", (Object)snapshotName, (Object)snapshotPath);
        } else {
            omMetrics.incNumSnapshotDeleteFails();
            LOG.error("Failed to delete snapshot '{}' under path '{}'", (Object)snapshotName, (Object)snapshotPath);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSnapshotDeleteRequest.java", OMSnapshotDeleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotDeleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 72);
    }
}

