/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneLockStrategy;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;

public class RegularBucketLockStrategy
implements OzoneLockStrategy {
    @Override
    public OMLockDetails acquireWriteLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OMFileRequest.validateBucket(omMetadataManager, volumeName, bucketName);
        return omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OMLockDetails releaseWriteLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) {
        return omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OMLockDetails acquireReadLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OMFileRequest.validateBucket(omMetadataManager, volumeName, bucketName);
        return omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OMLockDetails releaseReadLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) {
        return omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }
}

