/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.protobuf.RpcController;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerServiceGrpc;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.util.UUIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerServiceGrpc
extends OzoneManagerServiceGrpc.OzoneManagerServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerServiceGrpc.class);
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final OzoneManagerProtocolServerSideTranslatorPB omTranslator;

    OzoneManagerServiceGrpc(OzoneManagerProtocolServerSideTranslatorPB omTranslator) {
        this.omTranslator = omTranslator;
    }

    public void submitRequest(OzoneManagerProtocolProtos.OMRequest request, StreamObserver<OzoneManagerProtocolProtos.OMResponse> responseObserver) {
        LOG.debug("OzoneManagerServiceGrpc: OzoneManagerServiceImplBase processing s3g client submit request - for command {}", (Object)request.getCmdType().name());
        AtomicInteger callCount = new AtomicInteger(0);
        Server.getCurCall().set(new Server.Call(1, callCount.incrementAndGet(), null, null, RPC.RpcKind.RPC_PROTOCOL_BUFFER, OzoneManagerServiceGrpc.getClientId()));
        try {
            OzoneManagerProtocolProtos.OMResponse omResponse = this.omTranslator.submitRequest(NULL_RPC_CONTROLLER, request);
            responseObserver.onNext((Object)omResponse);
        }
        catch (Throwable e) {
            LOG.error("Failed to submit request", e);
            IOException ex = new IOException(e.getCause());
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(ex.getMessage()).asRuntimeException());
            return;
        }
        responseObserver.onCompleted();
    }

    private static byte[] getClientId() {
        return UUIDUtil.randomUUIDBytes();
    }
}

