/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om.lease;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LeaseRecoverable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="recover", customSynopsis={"ozone admin om lease recover --path=<path>"}, description={"Recover the lease of a specified file. Make sure to specify file system scheme if ofs:// is not the default."})
public class LeaseRecoverer
implements Callable<Void> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--path"}, required=true, description={"Path to the file"})
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String dbPath) {
        this.path = dbPath;
    }

    @Override
    public Void call() throws Exception {
        URI uri;
        block7: {
            OzoneConfiguration configuration = new OzoneConfiguration();
            uri = URI.create(this.path);
            try (FileSystem fs = FileSystem.get((URI)uri, (Configuration)configuration);){
                if (fs instanceof LeaseRecoverable) {
                    ((LeaseRecoverable)fs).recoverLease(new Path(uri));
                    break block7;
                }
                throw new IllegalArgumentException("Unsupported file system: " + fs.getScheme());
            }
        }
        System.out.println("Lease recovery SUCCEEDED on " + uri);
        return null;
    }
}

