/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneReplicaPipelineSafeModeRule
extends SafeModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(OneReplicaPipelineSafeModeRule.class);
    private int thresholdCount;
    private final Set<PipelineID> reportedPipelineIDSet = new HashSet<PipelineID>();
    private Set<PipelineID> oldPipelineIDSet;
    private int currentReportedPipelineCount = 0;
    private PipelineManager pipelineManager;
    private final double pipelinePercent;

    public OneReplicaPipelineSafeModeRule(EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager safeModeManager, ConfigurationSource configuration) {
        super(safeModeManager, eventQueue);
        this.pipelinePercent = configuration.getDouble("hdds.scm.safemode.atleast.one.node.reported.pipeline.pct", 0.9);
        Preconditions.checkArgument((this.pipelinePercent >= 0.0 && this.pipelinePercent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.atleast.one.node.reported.pipeline.pct value should be >= 0.0 and <= 1.0");
        this.pipelineManager = pipelineManager;
        this.initializeRule(false);
    }

    @Override
    protected TypedEvent<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> getEventType() {
        return SCMEvents.PIPELINE_REPORT;
    }

    @Override
    protected synchronized boolean validate() {
        return this.currentReportedPipelineCount >= this.thresholdCount;
    }

    @Override
    protected synchronized void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode report) {
        Preconditions.checkNotNull((Object)report);
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report1 : ((StorageContainerDatanodeProtocolProtos.PipelineReportsProto)report.getReport()).getPipelineReportList()) {
            Pipeline pipeline;
            try {
                pipeline = this.pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)report1.getPipelineID()));
            }
            catch (PipelineNotFoundException pnfe) {
                continue;
            }
            if (!RatisReplicationConfig.hasFactor((ReplicationConfig)pipeline.getReplicationConfig(), (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE) || !pipeline.isOpen() || this.reportedPipelineIDSet.contains(pipeline.getId()) || !this.oldPipelineIDSet.contains(pipeline.getId())) continue;
            this.getSafeModeMetrics().incCurrentHealthyPipelinesWithAtleastOneReplicaReportedCount();
            ++this.currentReportedPipelineCount;
            this.reportedPipelineIDSet.add(pipeline.getId());
        }
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. Pipelines with at least one datanode reported count is {}, required at least one datanode reported per pipeline count is {}", (Object)this.currentReportedPipelineCount, (Object)this.thresholdCount);
        }
    }

    @Override
    protected synchronized void cleanup() {
        this.reportedPipelineIDSet.clear();
    }

    @VisibleForTesting
    public synchronized int getThresholdCount() {
        return this.thresholdCount;
    }

    @VisibleForTesting
    public synchronized int getCurrentReportedPipelineCount() {
        return this.currentReportedPipelineCount;
    }

    @Override
    public String getStatusText() {
        String status = String.format("reported Ratis/THREE pipelines with at least one datanode (=%d) >= threshold (=%d)", this.getCurrentReportedPipelineCount(), this.getThresholdCount());
        status = this.updateStatusTextWithSamplePipelines(status);
        return status;
    }

    private synchronized String updateStatusTextWithSamplePipelines(String status) {
        Set samplePipelines = this.oldPipelineIDSet.stream().filter(element -> !this.reportedPipelineIDSet.contains(element)).limit(5L).collect(Collectors.toSet());
        if (!samplePipelines.isEmpty()) {
            String samplePipelineText = "Sample pipelines not satisfying the criteria : " + samplePipelines;
            status = status.concat("\n").concat(samplePipelineText);
        }
        return status;
    }

    @Override
    public synchronized void refresh(boolean forceRefresh) {
        if (forceRefresh) {
            this.initializeRule(true);
        } else if (!this.validate()) {
            this.initializeRule(true);
        }
    }

    private void initializeRule(boolean refresh) {
        this.oldPipelineIDSet = this.pipelineManager.getPipelines((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE), Pipeline.PipelineState.OPEN).stream().map(p -> p.getId()).collect(Collectors.toSet());
        int totalPipelineCount = this.oldPipelineIDSet.size();
        this.thresholdCount = (int)Math.ceil(this.pipelinePercent * (double)totalPipelineCount);
        if (refresh) {
            LOG.info("Refreshed Total pipeline count is {}, pipeline's with at least one datanode reported threshold count is {}", (Object)totalPipelineCount, (Object)this.thresholdCount);
        } else {
            LOG.info("Total pipeline count is {}, pipeline's with at least one datanode reported threshold count is {}", (Object)totalPipelineCount, (Object)this.thresholdCount);
        }
        this.getSafeModeMetrics().setNumPipelinesWithAtleastOneReplicaReportedThreshold(this.thresholdCount);
    }
}

