/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.EnumSet;
import java.util.Locale;
import org.apache.solr.common.SolrException;

public interface FacetParams {
    public static final String FACET = "facet";
    public static final String FACET_THREADS = "facet.threads";
    public static final String FACET_METHOD = "facet.method";
    public static final String FACET_METHOD_enum = "enum";
    public static final String FACET_METHOD_fc = "fc";
    public static final String FACET_METHOD_fcs = "fcs";
    public static final String FACET_METHOD_uif = "uif";
    public static final String FACET_QUERY = "facet.query";
    public static final String FACET_FIELD = "facet.field";
    public static final String FACET_OFFSET = "facet.offset";
    public static final String FACET_LIMIT = "facet.limit";
    public static final String FACET_MINCOUNT = "facet.mincount";
    public static final String FACET_ZEROS = "facet.zeros";
    public static final String FACET_MISSING = "facet.missing";
    public static final String FACET_OVERREQUEST = "facet.overrequest";
    public static final String FACET_OVERREQUEST_RATIO = "facet.overrequest.ratio";
    public static final String FACET_OVERREQUEST_COUNT = "facet.overrequest.count";
    @Deprecated
    public static final String FACET_DISTRIB = "facet.distrib";
    public static final String FACET_PIVOT = "facet.pivot";
    public static final String FACET_PIVOT_MINCOUNT = "facet.pivot.mincount";
    public static final String FACET_SORT = "facet.sort";
    public static final String FACET_SORT_COUNT = "count";
    public static final String FACET_SORT_COUNT_LEGACY = "true";
    public static final String FACET_SORT_INDEX = "index";
    public static final String FACET_SORT_INDEX_LEGACY = "false";
    public static final String FACET_PREFIX = "facet.prefix";
    public static final String FACET_CONTAINS = "facet.contains";
    public static final String FACET_MATCHES = "facet.matches";
    public static final String FACET_CONTAINS_IGNORE_CASE = "facet.contains.ignoreCase";
    public static final String FACET_EXCLUDETERMS = "facet.excludeTerms";
    public static final String FACET_ENUM_CACHE_MINDF = "facet.enum.cache.minDf";
    public static final String FACET_EXISTS = "facet.exists";
    public static final String FACET_DATE = "facet.date";
    public static final String FACET_DATE_START = "facet.date.start";
    public static final String FACET_DATE_END = "facet.date.end";
    public static final String FACET_DATE_GAP = "facet.date.gap";
    public static final String FACET_DATE_HARD_END = "facet.date.hardend";
    public static final String FACET_DATE_OTHER = "facet.date.other";
    public static final String FACET_DATE_INCLUDE = "facet.date.include";
    public static final String FACET_RANGE = "facet.range";
    public static final String FACET_RANGE_START = "facet.range.start";
    public static final String FACET_RANGE_END = "facet.range.end";
    public static final String FACET_RANGE_GAP = "facet.range.gap";
    public static final String FACET_RANGE_HARD_END = "facet.range.hardend";
    public static final String FACET_RANGE_OTHER = "facet.range.other";
    public static final String FACET_RANGE_INCLUDE = "facet.range.include";
    public static final String FACET_RANGE_METHOD = "facet.range.method";
    public static final String FACET_INTERVAL = "facet.interval";
    public static final String FACET_INTERVAL_SET = "facet.interval.set";
    public static final String FACET_HEATMAP = "facet.heatmap";
    public static final String FACET_HEATMAP_FORMAT = "facet.heatmap.format";
    public static final String FACET_HEATMAP_GEOM = "facet.heatmap.geom";
    public static final String FACET_HEATMAP_LEVEL = "facet.heatmap.gridLevel";
    public static final String FACET_HEATMAP_DIST_ERR_PCT = "facet.heatmap.distErrPct";
    public static final String FACET_HEATMAP_DIST_ERR = "facet.heatmap.distErr";
    public static final String FACET_HEATMAP_MAX_CELLS = "facet.heatmap.maxCells";

    public static enum FacetRangeMethod {
        FILTER,
        DV;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static FacetRangeMethod get(String label) {
            try {
                return FacetRangeMethod.valueOf(label.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, label + " is not a valid method for range faceting", (Throwable)e);
            }
        }

        public static FacetRangeMethod getDefault() {
            return FILTER;
        }
    }

    public static enum FacetRangeInclude {
        ALL,
        LOWER,
        UPPER,
        EDGE,
        OUTER;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static FacetRangeInclude get(String label) {
            try {
                return FacetRangeInclude.valueOf(label.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, label + " is not a valid type of for range 'include' information", (Throwable)e);
            }
        }

        public static EnumSet<FacetRangeInclude> parseParam(String[] param) {
            if (null == param || 0 == param.length) {
                return EnumSet.of(LOWER);
            }
            EnumSet<FacetRangeInclude> include = EnumSet.noneOf(FacetRangeInclude.class);
            for (String o : param) {
                include.add(FacetRangeInclude.get(o));
            }
            if (include.contains((Object)ALL)) {
                return EnumSet.allOf(FacetRangeInclude.class);
            }
            return include;
        }
    }

    public static enum FacetRangeOther {
        BEFORE,
        AFTER,
        BETWEEN,
        ALL,
        NONE;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static FacetRangeOther get(String label) {
            try {
                return FacetRangeOther.valueOf(label.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, label + " is not a valid type of 'other' range facet information", (Throwable)e);
            }
        }
    }
}

