/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hdfs.web.resources.StringParam;

public class AclPermissionParam
extends StringParam {
    public static final String NAME = "aclspec";
    public static final String DEFAULT = "";
    private static StringParam.Domain DOMAIN = new StringParam.Domain("aclspec", Pattern.compile("^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$"));

    public AclPermissionParam(String str) {
        super(DOMAIN, str == null || str.equals(DEFAULT) ? null : str);
    }

    public AclPermissionParam(List<AclEntry> acl) {
        super(DOMAIN, AclPermissionParam.parseAclSpec(acl).equals(DEFAULT) ? null : AclPermissionParam.parseAclSpec(acl));
    }

    @VisibleForTesting
    public static StringParam.Domain getAclPermissionPattern() {
        return DOMAIN;
    }

    @VisibleForTesting
    public static void setAclPermissionPattern(StringParam.Domain dm) {
        DOMAIN = dm;
    }

    public static void setAclPermissionPattern(String pattern) {
        DOMAIN = new StringParam.Domain(NAME, Pattern.compile(pattern));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<AclEntry> getAclPermission(boolean includePermission) {
        String v = (String)this.getValue();
        return v != null ? AclEntry.parseAclSpec((String)v, (boolean)includePermission) : AclEntry.parseAclSpec((String)DEFAULT, (boolean)includePermission);
    }

    private static String parseAclSpec(List<AclEntry> aclEntries) {
        if (aclEntries == null) {
            return null;
        }
        if (aclEntries.isEmpty()) {
            return DEFAULT;
        }
        if (aclEntries.size() == 1) {
            AclEntry entry = aclEntries.get(0);
            return entry == null ? DEFAULT : entry.toStringStable();
        }
        StringBuilder sb = new StringBuilder();
        Iterator<AclEntry> iter = aclEntries.iterator();
        sb.append(iter.next().toStringStable());
        while (iter.hasNext()) {
            AclEntry entry = iter.next();
            sb.append(',').append(entry == null ? DEFAULT : entry.toStringStable());
        }
        return sb.toString();
    }
}

