/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.debugger.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v108.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class Location {
    private final ScriptId scriptId;
    private final Integer lineNumber;
    private final Optional<Integer> columnNumber;

    public Location(ScriptId scriptId, Integer lineNumber, Optional<Integer> columnNumber) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = columnNumber;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Optional<Integer> getColumnNumber() {
        return this.columnNumber;
    }

    private static Location fromJson(JsonInput input) {
        ScriptId scriptId = null;
        Integer lineNumber = 0;
        Optional<Integer> columnNumber = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block10;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block10;
                }
                case "columnNumber": {
                    columnNumber = Optional.ofNullable(input.nextNumber().intValue());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Location(scriptId, lineNumber, columnNumber);
    }
}

