/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.eps;

import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.Charsets;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.eps.EpsDirectory;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.photoshop.PhotoshopTiffHandler;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class EpsReader {
    private int _previousTag;

    public void extract(@NotNull InputStream inputStream, @NotNull Metadata metadata) throws IOException {
        RandomAccessStreamReader reader = new RandomAccessStreamReader(inputStream);
        EpsDirectory directory = new EpsDirectory();
        metadata.addDirectory(directory);
        switch (reader.getInt32(0)) {
            case -976170042: {
                reader.setMotorolaByteOrder(false);
                int postScriptOffset = reader.getInt32(4);
                int postScriptLength = reader.getInt32(8);
                int wmfOffset = reader.getInt32(12);
                int wmfSize = reader.getInt32(16);
                int tifOffset = reader.getInt32(20);
                int tifSize = reader.getInt32(24);
                if (tifSize != 0) {
                    directory.setInt(32, tifSize);
                    directory.setInt(33, tifOffset);
                    try {
                        ByteArrayReader byteArrayReader = new ByteArrayReader(reader.getBytes(tifOffset, tifSize));
                        new TiffReader().processTiff(byteArrayReader, new PhotoshopTiffHandler(metadata, null), 0);
                    }
                    catch (TiffProcessingException ex) {
                        directory.addError("Unable to process TIFF data: " + ex.getMessage());
                    }
                } else if (wmfSize != 0) {
                    directory.setInt(34, wmfSize);
                    directory.setInt(35, wmfOffset);
                }
                this.extract(directory, metadata, new SequentialByteArrayReader(reader.getBytes(postScriptOffset, postScriptLength)));
                break;
            }
            case 622940243: {
                inputStream.reset();
                this.extract(directory, metadata, new StreamReader(inputStream));
                break;
            }
            default: {
                directory.addError("File type not supported.");
            }
        }
    }

    private void extract(@NotNull EpsDirectory directory, @NotNull Metadata metadata, @NotNull SequentialReader reader) throws IOException {
        StringBuilder line = new StringBuilder();
        while (true) {
            String name;
            char c;
            line.setLength(0);
            while ((c = (char)reader.getByte()) != '\r' && c != '\n') {
                line.append(c);
            }
            if (line.length() != 0 && line.charAt(0) != '%') break;
            int colonIndex = line.indexOf(":");
            if (colonIndex != -1) {
                name = line.substring(0, colonIndex).trim();
                String value = line.substring(colonIndex + 1).trim();
                this.addToDirectory(directory, name, value);
            } else {
                name = line.toString().trim();
            }
            if (name.equals("%BeginPhotoshop")) {
                EpsReader.extractPhotoshopData(metadata, reader);
                continue;
            }
            if (name.equals("%%BeginICCProfile")) {
                EpsReader.extractIccData(metadata, reader);
                continue;
            }
            if (!name.equals("%begin_xml_packet")) continue;
            EpsReader.extractXmpData(metadata, reader);
        }
    }

    private void addToDirectory(@NotNull EpsDirectory directory, String name, String value) throws IOException {
        Integer tag = EpsDirectory._tagIntegerMap.get(name);
        if (tag == null) {
            return;
        }
        switch (tag) {
            case 8: {
                EpsReader.extractImageData(directory, value);
                break;
            }
            case 36: {
                directory.setString(this._previousTag, directory.getString(this._previousTag) + " " + value);
                break;
            }
            default: {
                if (EpsDirectory._tagNameMap.containsKey(tag) && !directory.containsTag(tag)) {
                    directory.setString(tag, value);
                    this._previousTag = tag;
                    break;
                }
                this._previousTag = 0;
            }
        }
        this._previousTag = tag;
    }

    private static void extractImageData(@NotNull EpsDirectory directory, String imageData) throws IOException {
        directory.setString(8, imageData.trim());
        String[] imageDataParts = imageData.split(" ");
        int width = Integer.parseInt(imageDataParts[0]);
        int height = Integer.parseInt(imageDataParts[1]);
        int colorType = Integer.parseInt(imageDataParts[3]);
        if (!directory.containsTag(28)) {
            directory.setInt(28, width);
        }
        if (!directory.containsTag(29)) {
            directory.setInt(29, height);
        }
        if (!directory.containsTag(30)) {
            directory.setInt(30, colorType);
        }
        if (!directory.containsTag(31)) {
            int bytesPerPixel = 0;
            if (colorType == 1) {
                bytesPerPixel = 1;
            } else if (colorType == 2 || colorType == 3) {
                bytesPerPixel = 3;
            } else if (colorType == 4) {
                bytesPerPixel = 3;
            }
            if (bytesPerPixel != 0) {
                directory.setInt(31, bytesPerPixel * width * height);
            }
        }
    }

    private static void extractPhotoshopData(@NotNull Metadata metadata, @NotNull SequentialReader reader) throws IOException {
        byte[] buffer = EpsReader.decodeHexCommentBlock(reader);
        if (buffer != null) {
            new PhotoshopReader().extract(new SequentialByteArrayReader(buffer), buffer.length, metadata);
        }
    }

    private static void extractIccData(@NotNull Metadata metadata, @NotNull SequentialReader reader) throws IOException {
        byte[] buffer = EpsReader.decodeHexCommentBlock(reader);
        if (buffer != null) {
            new IccReader().extract(new ByteArrayReader(buffer), metadata);
        }
    }

    private static void extractXmpData(@NotNull Metadata metadata, @NotNull SequentialReader reader) throws IOException {
        byte[] bytes = EpsReader.readUntil(reader, "<?xpacket end=\"w\"?>".getBytes());
        String xmp = new String(bytes, Charsets.UTF_8);
        new XmpReader().extract(xmp, metadata);
    }

    private static byte[] readUntil(@NotNull SequentialReader reader, @NotNull byte[] sentinel) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int length = sentinel.length;
        int depth = 0;
        while (depth != length) {
            byte b = reader.getByte();
            depth = b == sentinel[depth] ? ++depth : 0;
            bytes.write(b);
        }
        return bytes.toByteArray();
    }

    @Nullable
    private static byte[] decodeHexCommentBlock(@NotNull SequentialReader reader) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        boolean AwaitingPercent = false;
        boolean AwaitingSpace = true;
        int AwaitingHex1 = 2;
        int AwaitingHex2 = 3;
        int state = 0;
        int carry = 0;
        boolean done = false;
        byte b = 0;
        while (!done) {
            b = reader.getByte();
            block0 : switch (state) {
                case 0: {
                    switch (b) {
                        case 10: 
                        case 13: 
                        case 32: {
                            break block0;
                        }
                        case 37: {
                            state = 1;
                            break block0;
                        }
                    }
                    return null;
                }
                case 1: {
                    switch (b) {
                        case 32: {
                            state = 2;
                            break block0;
                        }
                    }
                    done = true;
                    break;
                }
                case 2: {
                    int i = EpsReader.tryHexToInt(b);
                    if (i != -1) {
                        carry = i * 16;
                        state = 3;
                        break;
                    }
                    if (b == 13 || b == 10) {
                        state = 0;
                        break;
                    }
                    return null;
                }
                case 3: {
                    int i = EpsReader.tryHexToInt(b);
                    if (i == -1) {
                        return null;
                    }
                    bytes.write(carry + i);
                    state = 2;
                    break;
                }
            }
        }
        while (b != 10) {
            b = reader.getByte();
        }
        return bytes.toByteArray();
    }

    private static int tryHexToInt(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 65 + 10;
        }
        if (b >= 97 && b <= 102) {
            return b - 97 + 10;
        }
        return -1;
    }
}

