/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.text.html;

import java.io.IOException;
import java.io.Writer;
import org.archive.format.text.html.CDATALexer;
import org.archive.format.text.html.NodeUtils;
import org.archive.format.text.html.ParseObserver;
import org.htmlparser.Node;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;

public class LexParser
extends NodeUtils {
    ParseObserver obs;

    public LexParser(ParseObserver obs) {
        this.obs = obs;
    }

    public void doParse(CDATALexer lex) throws ParserException, IOException {
        this.doParse(lex, null);
    }

    public void doParse(CDATALexer lex, Writer w) throws ParserException, IOException {
        Node n;
        this.obs.handleDocumentStart();
        while ((n = lex.nextNode()) != null) {
            if (LexParser.isRemarkNode(n)) {
                this.obs.handleRemarkNode((RemarkNode)n);
            } else if (LexParser.isTextNode(n)) {
                TextNode tx = (TextNode)n;
                if (lex.inCSS()) {
                    this.obs.handleStyleNode(tx);
                } else if (lex.inJS()) {
                    this.obs.handleScriptNode(tx);
                } else {
                    this.obs.handleTextNode(tx);
                }
            } else {
                TagNode tn = (TagNode)n;
                if (tn.isEmptyXmlTag()) {
                    this.obs.handleTagEmpty(tn);
                } else if (tn.isEndTag()) {
                    this.obs.handleTagClose(tn);
                } else {
                    this.obs.handleTagOpen(tn);
                }
            }
            if (w == null) continue;
            w.write(n.toHtml(true));
        }
        this.obs.handleDocumentComplete();
    }
}

