/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalyzerProvider;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.opensearch.index.analysis.PreConfiguredCharFilter;
import org.opensearch.index.analysis.PreConfiguredTokenFilter;
import org.opensearch.index.analysis.PreConfiguredTokenizer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.indices.analysis.AnalysisModule;

public interface AnalysisPlugin {
    default public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.emptyMap();
    }

    default public List<PreBuiltAnalyzerProviderFactory> getPreBuiltAnalyzerProviderFactories() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        return Collections.emptyList();
    }

    default public Map<String, Dictionary> getHunspellDictionaries() {
        return Collections.emptyMap();
    }

    public static <T> AnalysisModule.AnalysisProvider<T> requiresAnalysisSettings(final AnalysisModule.AnalysisProvider<T> provider) {
        return new AnalysisModule.AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }
}

