/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class JmsMessage {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String content;
    private String charset = "UTF-8";
    private String correlationID;
    private String deliveryMode;
    private String destination;
    private String expiration;
    private String messageId;
    private int priority;
    private boolean redelivered;
    private String replyTo;
    private String timestamp;
    private String type;

    public JmsMessage(Message message) {
        try {
            this.initFromMessage(message);
        }
        catch (JMSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void initFromMessage(Message message) throws JMSException {
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = message.getObjectProperty(key);
            this.properties.put(key, value);
        }
        this.correlationID = message.getJMSCorrelationID();
        this.deliveryMode = message.getJMSDeliveryMode() == 1 ? "Non Persistent" : "Persistent";
        Destination destinationDest = message.getJMSDestination();
        if (destinationDest != null) {
            this.destination = destinationDest.toString();
        }
        this.expiration = message.getJMSExpiration() > 0L ? new Date(message.getJMSExpiration()).toString() : "Never";
        this.messageId = message.getJMSMessageID();
        this.priority = message.getJMSPriority();
        this.redelivered = message.getJMSRedelivered();
        Destination replyToDest = message.getJMSReplyTo();
        if (replyToDest != null) {
            this.replyTo = replyToDest.toString();
        }
        this.timestamp = message.getJMSTimestamp() > 0L ? new Date(message.getJMSTimestamp()).toString() : "";
        this.type = message.getJMSType();
        this.content = this.getMessageContent(message);
    }

    private String getMessageContent(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof BytesMessage) {
            BytesMessage bMessage = (BytesMessage)message;
            long length = bMessage.getBodyLength();
            byte[] content = new byte[(int)length];
            bMessage.readBytes(content);
            try {
                return new String(content, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return "";
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getContent() {
        return this.content;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }
}

