/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.audit;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.apache.karaf.jaas.modules.JAASUtils;

public abstract class AbstractAuditLoginModule
implements LoginModule {
    protected Subject subject;
    private CallbackHandler handler;
    private String username;
    private boolean enabled;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.enabled = Boolean.parseBoolean(JAASUtils.getString(options, "enabled"));
        this.handler = callbackHandler;
    }

    protected abstract void audit(Action var1, String var2);

    @Override
    public boolean login() throws LoginException {
        NameCallback user = new NameCallback("User name:");
        Callback[] callbacks = new Callback[]{user};
        try {
            this.handler.handle(callbacks);
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to process callback: " + e.getMessage()).initCause(e);
        }
        if (callbacks.length != 1) {
            throw new IllegalStateException("Number of callbacks changed by server!");
        }
        user = (NameCallback)callbacks[0];
        this.username = user.getName();
        if (this.enabled && this.username != null) {
            this.audit(Action.ATTEMPT, this.username);
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.enabled && this.username != null) {
            this.audit(Action.SUCCESS, this.username);
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.enabled && this.username != null) {
            this.audit(Action.FAILURE, this.username);
            this.username = null;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.enabled && this.username != null) {
            this.audit(Action.LOGOUT, this.username);
            this.username = null;
        }
        return false;
    }

    protected String getPrincipalInfo() {
        List principalInfos = this.subject.getPrincipals(ClientPrincipal.class).stream().map(ClientPrincipal::getName).collect(Collectors.toList());
        String principalInfo = principalInfos.size() > 0 ? String.join((CharSequence)", ", principalInfos) : "no client principals found";
        return principalInfo;
    }

    static enum Action {
        ATTEMPT,
        SUCCESS,
        FAILURE,
        LOGOUT;

    }
}

