/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourcesRepository
extends BaseRepository {
    private final Set<Resource> resources = new LinkedHashSet<Resource>();
    private final Map<String, Predicate<Map<String, Object>>> cache = new ConcurrentHashMap<String, Predicate<Map<String, Object>>>();

    public ResourcesRepository() {
    }

    public ResourcesRepository(Resource resource) {
        this();
        this.add(resource);
    }

    public ResourcesRepository(Collection<? extends Resource> resource) {
        this();
        this.addAll(resource);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return ResourceUtils.findProviders(requirements, this::findProvider);
    }

    public List<Capability> findProvider(Requirement requirement) {
        String namespace = requirement.getNamespace();
        return this.resources.stream().flatMap(resource -> ResourceUtils.capabilityStream(resource, namespace)).filter(ResourceUtils.matcher(requirement, this::filterPredicate)).collect(ResourceUtils.toCapabilities());
    }

    private Predicate<Map<String, Object>> filterPredicate(String filterString) {
        if (filterString == null) {
            return ResourceUtils.filterPredicate(null);
        }
        return this.cache.computeIfAbsent(filterString, ResourceUtils::filterPredicate);
    }

    public void add(Resource resource) {
        if (resource != null) {
            this.resources.add(resource);
        }
    }

    public void addAll(Collection<? extends Resource> resources) {
        resources.forEach(this::add);
    }

    protected void set(Collection<? extends Resource> resources) {
        this.resources.clear();
        this.addAll(resources);
    }

    public List<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    public static Collector<Capability, List<Capability>, List<Capability>> toCapabilities() {
        return ResourceUtils.toCapabilities();
    }

    public static Collector<Resource, ResourcesRepository, ResourcesRepository> toResourcesRepository() {
        return Collector.of(ResourcesRepository::new, ResourcesRepository::add, ResourcesRepository::combiner, new Collector.Characteristics[0]);
    }

    private static ResourcesRepository combiner(ResourcesRepository t, ResourcesRepository u) {
        t.addAll(u.resources);
        return t;
    }

    public String toString() {
        return this.resources.toString();
    }
}

