/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BitSetDocIdStream;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;

final class DenseConjunctionBulkScorer
extends BulkScorer {
    static final int WINDOW_SIZE = 4096;
    static final int DENSITY_THRESHOLD_INVERSE = 32;
    private final int maxDoc;
    private final List<DisiWrapper> iterators;
    private final SimpleScorable scorable;
    private final FixedBitSet windowMatches = new FixedBitSet(4096);
    private final FixedBitSet clauseWindowMatches = new FixedBitSet(4096);
    private final List<DocIdSetIterator> windowApproximations = new ArrayList<DocIdSetIterator>();
    private final List<TwoPhaseIterator> windowTwoPhases = new ArrayList<TwoPhaseIterator>();

    static DenseConjunctionBulkScorer of(List<Scorer> filters, int maxDoc, float constantScore) {
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhases = new ArrayList<TwoPhaseIterator>();
        for (Scorer filter : filters) {
            TwoPhaseIterator twoPhase = filter.twoPhaseIterator();
            if (twoPhase != null) {
                twoPhases.add(twoPhase);
                continue;
            }
            iterators.add(filter.iterator());
        }
        return new DenseConjunctionBulkScorer(iterators, twoPhases, maxDoc, constantScore);
    }

    DenseConjunctionBulkScorer(List<DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhases, int maxDoc, float constantScore) {
        if (iterators.isEmpty() && twoPhases.isEmpty()) {
            throw new IllegalArgumentException("Expected one or more iterators, got 0");
        }
        this.maxDoc = maxDoc;
        this.iterators = new ArrayList<DisiWrapper>();
        for (DocIdSetIterator iterator : iterators) {
            this.iterators.add(new DisiWrapper(iterator));
        }
        for (TwoPhaseIterator twoPhase : twoPhases) {
            this.iterators.add(new DisiWrapper(twoPhase));
        }
        this.iterators.sort(Comparator.comparing(w -> w.approximation().cost()));
        this.scorable = new SimpleScorable();
        this.scorable.score = constantScore;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        collector.setScorer(this.scorable);
        List<DisiWrapper> iterators = this.iterators;
        if (collector.competitiveIterator() != null) {
            iterators = new ArrayList<DisiWrapper>(iterators);
            iterators.add(new DisiWrapper(collector.competitiveIterator()));
        }
        for (DisiWrapper w : iterators) {
            min2 = Math.max(min2, w.approximation().docID());
        }
        max2 = Math.min(max2, this.maxDoc);
        DisiWrapper lead = iterators.get(0);
        if (lead.docID() < min2) {
            min2 = lead.approximation.advance(min2);
        }
        while (min2 < max2) {
            if (this.scorable.minCompetitiveScore > this.scorable.score) {
                return Integer.MAX_VALUE;
            }
            min2 = this.scoreWindow(collector, acceptDocs, iterators, min2, max2);
        }
        if (lead.docID() > max2) {
            return lead.docID();
        }
        if (max2 >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        return max2;
    }

    private static int advance(FixedBitSet set, int i) {
        if (i >= 4096) {
            return Integer.MAX_VALUE;
        }
        return set.nextSetBit(i);
    }

    private int scoreWindow(LeafCollector collector, Bits acceptDocs, List<DisiWrapper> iterators, int min2, int max2) throws IOException {
        for (DisiWrapper w : iterators) {
            min2 = w.docID() >= min2 ? w.docID() : w.approximation().advance(min2);
            if (min2 < max2) continue;
            return min2;
        }
        int minDocIDRunEnd = max2;
        int minRunEndThreshold = MathUtil.unsignedMin(min2 + 2048, max2);
        for (DisiWrapper w : iterators) {
            int docIdRunEnd = w.docIDRunEnd();
            if (w.docID() > min2 || docIdRunEnd < minRunEndThreshold) {
                this.windowApproximations.add(w.approximation());
                if (w.twoPhase() == null) continue;
                this.windowTwoPhases.add(w.twoPhase());
                continue;
            }
            minDocIDRunEnd = Math.min(minDocIDRunEnd, docIdRunEnd);
        }
        if (acceptDocs == null && this.windowApproximations.isEmpty()) {
            collector.collectRange(min2, minDocIDRunEnd);
            return minDocIDRunEnd;
        }
        int bitsetWindowMax = MathUtil.unsignedMin(minDocIDRunEnd, 4096 + min2);
        if (this.windowTwoPhases.isEmpty()) {
            this.scoreWindowUsingBitSet(collector, acceptDocs, this.windowApproximations, min2, bitsetWindowMax);
        } else {
            this.windowTwoPhases.sort(Comparator.comparingDouble(TwoPhaseIterator::matchCost));
            DenseConjunctionBulkScorer.scoreWindowUsingLeapFrog(collector, acceptDocs, this.windowApproximations, this.windowTwoPhases, min2, bitsetWindowMax);
            this.windowTwoPhases.clear();
        }
        this.windowApproximations.clear();
        return bitsetWindowMax;
    }

    private void scoreWindowUsingBitSet(LeafCollector collector, Bits acceptDocs, List<DocIdSetIterator> iterators, int windowBase, int windowMax) throws IOException {
        int upTo;
        assert (windowMax > windowBase);
        assert (this.windowMatches.scanIsEmpty());
        assert (this.clauseWindowMatches.scanIsEmpty());
        if (iterators.isEmpty()) {
            this.windowMatches.set(0, windowMax - windowBase);
        } else {
            DocIdSetIterator lead = iterators.get(0);
            if (lead.docID() < windowBase) {
                lead.advance(windowBase);
            }
            lead.intoBitSet(windowMax, this.windowMatches, windowBase);
        }
        if (acceptDocs != null) {
            acceptDocs.applyMask(this.windowMatches, windowBase);
        }
        int windowSize = windowMax - windowBase;
        int threshold = windowSize / 32;
        for (upTo = 1; upTo < iterators.size() && this.windowMatches.cardinality() >= threshold; ++upTo) {
            DocIdSetIterator other = iterators.get(upTo);
            if (other.docID() < windowBase) {
                other.advance(windowBase);
            }
            other.intoBitSet(windowMax, this.clauseWindowMatches, windowBase);
            this.windowMatches.and(this.clauseWindowMatches);
            this.clauseWindowMatches.clear();
        }
        if (upTo < iterators.size()) {
            int windowMatch = this.windowMatches.nextSetBit(0);
            block1: while (windowMatch != Integer.MAX_VALUE) {
                int doc = windowBase + windowMatch;
                for (int i = upTo; i < iterators.size(); ++i) {
                    DocIdSetIterator other = iterators.get(i);
                    int otherDoc = other.docID();
                    if (otherDoc < doc) {
                        otherDoc = other.advance(doc);
                    }
                    if (doc == otherDoc) continue;
                    windowMatch = DenseConjunctionBulkScorer.advance(this.windowMatches, otherDoc - windowBase);
                    continue block1;
                }
                collector.collect(doc);
                windowMatch = DenseConjunctionBulkScorer.advance(this.windowMatches, windowMatch + 1);
            }
        } else {
            collector.collect(new BitSetDocIdStream(this.windowMatches, windowBase));
        }
        this.windowMatches.clear();
    }

    private static void scoreWindowUsingLeapFrog(LeafCollector collector, Bits acceptDocs, List<DocIdSetIterator> approximations, List<TwoPhaseIterator> twoPhases, int min2, int max2) throws IOException {
        assert (twoPhases.size() > 0);
        assert (approximations.size() >= twoPhases.size());
        if (approximations.size() == 1) {
            assert (twoPhases.size() == 1);
            DocIdSetIterator approximation = approximations.get(0);
            TwoPhaseIterator twoPhase = twoPhases.get(0);
            if (approximation.docID() < min2) {
                approximation.advance(min2);
            }
            int doc = approximation.docID();
            while (doc < max2) {
                if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                    collector.collect(doc);
                }
                doc = approximation.nextDoc();
            }
        } else {
            DocIdSetIterator lead1 = approximations.get(0);
            DocIdSetIterator lead2 = approximations.get(1);
            if (lead1.docID() < min2) {
                lead1.advance(min2);
            }
            int doc = lead1.docID();
            block1: while (doc < max2) {
                if (acceptDocs != null && !acceptDocs.get(doc)) {
                    doc = lead1.nextDoc();
                    continue;
                }
                int doc2 = lead2.docID();
                if (doc2 < doc) {
                    doc2 = lead2.advance(doc);
                }
                if (doc != doc2) {
                    doc = lead1.advance(Math.min(doc2, max2));
                    continue;
                }
                for (int i = 2; i < approximations.size(); ++i) {
                    DocIdSetIterator other = approximations.get(i);
                    int docN = other.docID();
                    if (docN < doc) {
                        docN = other.advance(doc);
                    }
                    if (doc == docN) continue;
                    doc = lead1.advance(Math.min(docN, max2));
                    continue block1;
                }
                for (TwoPhaseIterator twoPhase : twoPhases) {
                    if (twoPhase.matches()) continue;
                    doc = lead1.nextDoc();
                    continue block1;
                }
                collector.collect(doc);
                doc = lead1.nextDoc();
            }
        }
    }

    @Override
    public long cost() {
        return this.iterators.get(0).approximation().cost();
    }

    private record DisiWrapper(DocIdSetIterator approximation, TwoPhaseIterator twoPhase) {
        DisiWrapper(DocIdSetIterator iterator) {
            this(iterator, null);
        }

        DisiWrapper(TwoPhaseIterator twoPhase) {
            this(twoPhase.approximation(), twoPhase);
        }

        int docID() {
            return this.approximation().docID();
        }

        int docIDRunEnd() throws IOException {
            if (this.twoPhase() == null) {
                return this.approximation().docIDRunEnd();
            }
            return this.twoPhase().docIDRunEnd();
        }
    }
}

