/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.access.AccessGeoSPARQL;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class GenericGeometryPropertyFunction
extends PFuncSimple {
    protected abstract NodeValue applyPredicate(GeometryWrapper var1);

    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        if (subject.isConcrete() && object.isLiteral()) {
            return this.bothBound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isVariable() && object.isVariable()) {
            return this.bothUnbound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isConcrete() && object.isVariable()) {
            return this.objectUnbound(binding, subject, predicate, object, execCxt);
        }
        return this.subjectUnbound(binding, subject, predicate, object, execCxt);
    }

    protected Node getGeometryLiteral(Node subject, Node predicate, Graph graph) throws ExprEvalException {
        try {
            if (graph.contains(subject, predicate, null)) {
                return G.getSP(graph, subject, predicate);
            }
            Node geomLiteral = AccessGeoSPARQL.getGeoLiteral(graph, subject);
            if (geomLiteral != null) {
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geomLiteral);
                NodeValue predicateResult = this.applyPredicate(geometryWrapper);
                return predicateResult.asNode();
            }
            return null;
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    private QueryIterator bothBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        Node geometryLiteral = this.getGeometryLiteral(subject, predicate, graph);
        if (geometryLiteral != null && object.sameTermAs(geometryLiteral)) {
            return QueryIterSingleton.create(binding, execCxt);
        }
        return QueryIterNullIterator.create(execCxt);
    }

    private QueryIterator subjectUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        AtomicBoolean cancel = execCxt.getCancelSignal();
        ExtendedIterator<Triple> subjectTriples = AccessGeoSPARQL.findSpecificGeoLiterals(cancel, graph);
        Var subjectVar = Var.alloc(subject.getName());
        ExtendedIterator<Binding> iterator = subjectTriples.mapWith(Triple::getSubject).mapWith(node -> BindingFactory.binding(binding, subjectVar, node));
        QueryIter queryIter = QueryIter.flatMap(QueryIterPlainWrapper.create(iterator, execCxt), b -> this.bothBound((Binding)b, b.get(subjectVar), predicate, object, execCxt), execCxt);
        return queryIter;
    }

    private QueryIterator objectUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        Node geometryLiteral = this.getGeometryLiteral(subject, predicate, graph);
        if (geometryLiteral != null) {
            return QueryIterSingleton.create(binding, Var.alloc(object.getName()), geometryLiteral, execCxt);
        }
        return QueryIterNullIterator.create(execCxt);
    }

    private QueryIterator bothUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        AtomicBoolean cancel = execCxt.getCancelSignal();
        ExtendedIterator<Triple> subjectTriples = AccessGeoSPARQL.findSpecificGeoLiterals(cancel, graph);
        Var subjectVar = Var.alloc(subject.getName());
        ExtendedIterator<Binding> iterator = subjectTriples.mapWith(Triple::getSubject).mapWith(node -> BindingFactory.binding(binding, subjectVar, node));
        QueryIter queryIter = QueryIter.flatMap(QueryIterPlainWrapper.create(iterator, execCxt), b -> this.objectUnbound((Binding)b, b.get(subjectVar), predicate, object, execCxt), execCxt);
        return queryIter;
    }
}

