/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.http.PushBuilder;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.util.URIUtil;

@Deprecated(since="12.1.0")
class PushBuilderImpl
implements PushBuilder {
    private final ServletContextRequest _request;
    private final HttpFields.Mutable _headers;
    private String _method;
    private String _query;
    private String _sessionId;
    private String _path;

    public PushBuilderImpl(ServletContextRequest request, HttpFields.Mutable headers, String sessionId) {
        this._request = request;
        this._headers = headers;
        this._method = request.getMethod();
        this._query = request.getHttpURI().getQuery();
        this._sessionId = sessionId;
    }

    @Override
    public PushBuilder method(String method) {
        HttpMethod httpMethod = HttpMethod.fromString(Objects.requireNonNull(method));
        if (httpMethod == null || !httpMethod.isSafe() || httpMethod == HttpMethod.OPTIONS || httpMethod == HttpMethod.TRACE) {
            throw new IllegalArgumentException("method not allowed for push: " + method);
        }
        this._method = httpMethod.asString();
        return this;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this._query = queryString;
        return this;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this._sessionId = sessionId;
        return this;
    }

    @Override
    public PushBuilder setHeader(String name, String value) {
        this._headers.put(name, value);
        return this;
    }

    @Override
    public PushBuilder addHeader(String name, String value) {
        this._headers.add(name, value);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name) {
        this._headers.remove(name);
        return this;
    }

    @Override
    public PushBuilder path(String path) {
        this._path = path;
        return this;
    }

    @Override
    public void push() {
        String pushPath = this.getPath();
        if (pushPath == null || pushPath.isBlank()) {
            throw new IllegalStateException("invalid push path: " + pushPath);
        }
        String query2 = this.getQueryString();
        Object pushQuery = query2;
        int q = pushPath.indexOf(63);
        if (q > 0) {
            pushQuery = pushPath.substring(q + 1);
            if (query2 != null) {
                pushQuery = (String)pushQuery + "&" + query2;
            }
            pushPath = pushPath.substring(0, q);
        }
        if (!pushPath.startsWith("/")) {
            pushPath = URIUtil.addPaths(this._request.getServletContext().getContextPath(), pushPath);
        }
        String pushParam = null;
        if (this._sessionId != null && this._request.getServletApiRequest().isRequestedSessionIdFromURL()) {
            pushParam = "jsessionid=" + this._sessionId;
        }
        HttpURI.Mutable pushURI = HttpURI.build(this._request.getHttpURI(), pushPath, pushParam, (String)pushQuery).normalize();
        MetaData.Request push = new MetaData.Request(this._request.getBeginNanoTime(), this._method, pushURI, this._request.getConnectionMetaData().getHttpVersion(), this._headers);
        this._request.push(push);
        this._path = null;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public String getQueryString() {
        return this._query;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    public Set<String> getHeaderNames() {
        return this._headers.getFieldNamesCollection();
    }

    @Override
    public String getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public String getPath() {
        return this._path;
    }
}

