/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public final class ConstantScoreQuery
extends Query {
    private final Query query;

    public ConstantScoreQuery(Query query2) {
        this.query = Objects.requireNonNull(query2, "Query must not be null");
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten instanceof BoostQuery) {
            rewritten = ((BoostQuery)rewritten).getQuery();
        } else if (rewritten instanceof ConstantScoreQuery) {
            rewritten = ((ConstantScoreQuery)rewritten).getQuery();
        } else if (rewritten instanceof BooleanQuery) {
            rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
        }
        if (rewritten.getClass() == MatchNoDocsQuery.class) {
            return rewritten;
        }
        if (rewritten != this.query) {
            return new ConstantScoreQuery(rewritten);
        }
        if (rewritten.getClass() == ConstantScoreQuery.class) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            return new ConstantScoreQuery(((BoostQuery)rewritten).getQuery());
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.FILTER, this));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        ScoreMode innerScoreMode = scoreMode.isExhaustive() ? ScoreMode.COMPLETE_NO_SCORES : ScoreMode.TOP_DOCS;
        final Weight innerWeight = searcher.createWeight(this.query, innerScoreMode, 1.0f);
        if (scoreMode.needsScores()) {
            return new ConstantScoreWeight(this, this, boost){

                @Override
                public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                    final ScorerSupplier innerScorerSupplier = innerWeight.scorerSupplier(context2);
                    if (innerScorerSupplier == null) {
                        return null;
                    }
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            Scorer innerScorer = innerScorerSupplier.get(leadCost);
                            TwoPhaseIterator twoPhaseIterator = innerScorer.twoPhaseIterator();
                            if (twoPhaseIterator == null) {
                                return new ConstantScoreScorer(this.score(), scoreMode, innerScorer.iterator());
                            }
                            return new ConstantScoreScorer(this.score(), scoreMode, twoPhaseIterator);
                        }

                        @Override
                        public BulkScorer bulkScorer() throws IOException {
                            if (!scoreMode.isExhaustive()) {
                                return super.bulkScorer();
                            }
                            BulkScorer innerScorer = innerScorerSupplier.bulkScorer();
                            if (innerScorer == null) {
                                return null;
                            }
                            return new ConstantBulkScorer(innerScorer, innerWeight, this.score());
                        }

                        @Override
                        public long cost() {
                            return innerScorerSupplier.cost();
                        }
                    };
                }

                @Override
                public Matches matches(LeafReaderContext context2, int doc) throws IOException {
                    return innerWeight.matches(context2, doc);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return innerWeight.isCacheable(ctx);
                }

                @Override
                public int count(LeafReaderContext context2) throws IOException {
                    return innerWeight.count(context2);
                }
            };
        }
        return innerWeight;
    }

    @Override
    public String toString(String field) {
        return "ConstantScore(" + this.query.toString(field) + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals(((ConstantScoreQuery)other).query);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    protected static class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float theScore) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = theScore;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(collector), acceptDocs, min2, max2);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.in.setScorer(new FilterScorable(scorer){

                        @Override
                        public float score() {
                            return theScore;
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

