/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.tartarus.snowball.SnowballStemmer;

public final class SnowballFilter
extends TokenFilter {
    private final SnowballStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public SnowballFilter(TokenStream input, SnowballStemmer stemmer) {
        super(input);
        this.stemmer = Objects.requireNonNull(stemmer, "stemmer");
    }

    public SnowballFilter(TokenStream in, String name) {
        super(in);
        Objects.requireNonNull(name, "name");
        if (name.equals("German2")) {
            name = "German";
        }
        try {
            Class<SnowballStemmer> stemClass = Class.forName("org.tartarus.snowball.ext." + name + "Stemmer").asSubclass(SnowballStemmer.class);
            this.stemmer = stemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException("Invalid stemmer class specified: " + name, e2);
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                char[] termBuffer = this.termAtt.buffer();
                int length = this.termAtt.length();
                this.stemmer.setCurrent(termBuffer, length);
                this.stemmer.stem();
                char[] finalTerm = this.stemmer.getCurrentBuffer();
                int newLength = this.stemmer.getCurrentBufferLength();
                if (finalTerm != termBuffer) {
                    this.termAtt.copyBuffer(finalTerm, 0, newLength);
                } else {
                    this.termAtt.setLength(newLength);
                }
            }
            return true;
        }
        return false;
    }
}

