/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.List;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.system.G;

public class Parameters {
    static List<Parameter> parseParameters(Graph shapesGraph, Node sccNode) {
        List<Parameter> params = G.listSP(shapesGraph, sccNode, SHACL.parameter).stream().map(pn -> Parameters.parseParameter(shapesGraph, sccNode, pn)).toList();
        return params;
    }

    private static Parameter parseParameter(Graph shapesGraph, Node sccNode, Node parameterNode) {
        Node path = G.getZeroOrOneSP(shapesGraph, parameterNode, SHACL.path);
        if (!path.isURI()) {
            throw new ShaclParseException("SparqlConstraintComponent: Not a URI for parameter name: " + String.valueOf(path));
        }
        String sparqlName = path.getLocalName();
        boolean isOptional = G.contains(shapesGraph, parameterNode, SHACL.optional, C.TRUE);
        List<Constraint> constraints = null;
        return new Parameter(path, sparqlName, isOptional, constraints);
    }

    public static MultiValuedMap<Parameter, Node> parameterValues(Graph shapesGraph, Node sh, SparqlComponent scc) {
        ListValuedMap<Parameter, Node> paramValues = MultiMapUtils.newListValuedHashMap();
        scc.getParams().forEach(param -> {
            List<Node> values = G.listSP(shapesGraph, sh, param.getParameterPath());
            if (!values.isEmpty()) {
                paramValues.putAll((Parameter)param, (Iterable<Node>)values);
            }
        });
        return paramValues;
    }

    public static boolean doesShapeHaveAllParameters(Graph shapesGraph, Node sh, List<Node> required) {
        for (Node p : required) {
            if (G.contains(shapesGraph, sh, p, null)) continue;
            return false;
        }
        return true;
    }
}

