/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.arp1.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.rdfxml.arp1.ALiteral;
import org.apache.jena.rdfxml.arp1.ARPErrorNumbers;
import org.apache.jena.rdfxml.arp1.ARPHandlers;
import org.apache.jena.rdfxml.arp1.ARPOptions;
import org.apache.jena.rdfxml.arp1.AResource;
import org.apache.jena.rdfxml.arp1.ExtendedHandler;
import org.apache.jena.rdfxml.arp1.FatalParsingErrorException;
import org.apache.jena.rdfxml.arp1.ParseException;
import org.apache.jena.rdfxml.arp1.StatementHandler;
import org.apache.jena.rdfxml.arp1.impl.ANode;
import org.apache.jena.rdfxml.arp1.impl.ARPLocation;
import org.apache.jena.rdfxml.arp1.impl.ARPResource;
import org.apache.jena.rdfxml.arp1.impl.AResourceInternal;
import org.apache.jena.rdfxml.arp1.impl.AbsXMLContext;
import org.apache.jena.rdfxml.arp1.impl.LexicalHandlerImpl;
import org.apache.jena.rdfxml.arp1.impl.Names;
import org.apache.jena.rdfxml.arp1.impl.Taint;
import org.apache.jena.rdfxml.arp1.impl.WrappedException;
import org.apache.jena.rdfxml.arp1.impl.XMLBaselessContext;
import org.apache.jena.rdfxml.arp1.states.Frame;
import org.apache.jena.rdfxml.arp1.states.FrameI;
import org.apache.jena.rdfxml.arp1.states.LookingForRDF;
import org.apache.jena.rdfxml.arp1.states.StartStateRDForDescription;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLHandler
extends LexicalHandlerImpl
implements ARPErrorNumbers,
Names {
    boolean encodingProblems = false;
    protected Map<IRIx, Map<String, ARPLocation>> idsUsed = new HashMap<IRIx, Map<String, ARPLocation>>();
    protected int idsUsedCount = 0;
    FrameI frame;
    Locator locator;
    private static final boolean DEBUG = false;
    private boolean allowRelativeReferences = false;
    private ARPOptions options = ARPOptions.createNewOptions();
    private ARPHandlers handlers = ARPHandlers.createNewHandlers();
    private Map<String, Object> nodeIdUserData;
    private IRIProvider provider = null;
    private IRIx sameDocRef;
    private StatementHandler badStatementHandler = nullStatementHandler;
    public static final StatementHandler nullStatementHandler = new StatementHandler(){

        @Override
        public void statement(AResource s, AResource p, AResource o) {
        }

        @Override
        public void statement(AResource s, AResource p, ALiteral o) {
        }
    };
    public static final ExtendedHandler nullScopeHandler = new ExtendedHandler(){

        @Override
        public void endBNodeScope(AResource bnode2) {
        }

        @Override
        public void startRDF() {
        }

        @Override
        public void endRDF() {
        }

        @Override
        public boolean discardNodesWithNodeID() {
            return true;
        }
    };

    public void triple(ANode s, ANode p, ANode o) {
        boolean bad = s.isTainted() || p.isTainted() || o.isTainted();
        StatementHandler stmt = bad ? this.badStatementHandler : this.handlers.getStatementHandler();
        AResourceInternal subj = (AResourceInternal)s;
        AResourceInternal pred = (AResourceInternal)p;
        if (!bad) {
            subj.setHasBeenUsed();
        }
        if (o instanceof AResource) {
            AResourceInternal obj = (AResourceInternal)o;
            if (!bad) {
                obj.setHasBeenUsed();
            }
            stmt.statement((AResource)subj, (AResource)pred, obj);
        } else {
            stmt.statement((AResource)subj, (AResource)pred, (ALiteral)o);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXParseException {
        try {
            this.checkNamespaceURI(uri);
        }
        catch (IRIException ex) {
            ARPLocation aLoc = this.frame instanceof Frame ? new ARPLocation(((Frame)this.frame).arp.getLocator()) : new ARPLocation(null);
            throw new ParseException(2, aLoc, ex.getMessage());
        }
        this.handlers.getNamespaceHandler().startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.handlers.getNamespaceHandler().endPrefixMapping(prefix);
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
        if (Thread.interrupted()) {
            this.warning(null, 302, "Interrupt detected.");
        }
        FrameI oldFrame = this.frame;
        this.frame = this.frame.startElement(uri, localName, rawName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.frame.endElement();
        this.frame = this.frame.getParent();
        this.frame.afterChild();
    }

    public static String getSimpleName(Class<? extends FrameI> c) {
        String[] rslt = c.getName().split("\\.");
        return rslt[rslt.length - 1];
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.frame.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    void setUserData(String nodeId, Object v) {
        this.nodeIdUserData.put(nodeId, v);
    }

    Object getUserData(String nodeId) {
        return this.nodeIdUserData.get(nodeId);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXParseException {
        this.frame.comment(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.frame.processingInstruction(target, data);
    }

    public void warning(Taint taintMe, int id, String msg) throws SAXParseException {
        if (this.options.getErrorMode(id) != 0) {
            this.warning(taintMe, id, this.location(), msg);
        }
    }

    void warning(Taint taintMe, int id, ARPLocation loc, String msg) throws SAXParseException {
        if (this.options.getErrorMode(id) != 0) {
            this.warning(taintMe, id, new ParseException(id, loc, msg){
                private static final long serialVersionUID = 1990910846204964756L;
            });
        }
    }

    void generalError(int id, Exception e2) throws SAXParseException {
        ARPLocation where = new ARPLocation(this.locator);
        this.warning(null, id, new ParseException(id, where, e2));
    }

    void warning(Taint taintMe, int id, SAXParseException e2) throws SAXParseException {
        try {
            switch (this.options.getErrorMode(id)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.handlers.getErrorHandler().warning(e2);
                    break;
                }
                case 2: {
                    if (taintMe != null) {
                        taintMe.taint();
                    }
                    this.handlers.getErrorHandler().error(e2);
                    break;
                }
                case 3: {
                    this.handlers.getErrorHandler().fatalError(e2);
                }
            }
        }
        catch (SAXParseException xx) {
            throw xx;
        }
        catch (SAXException ee) {
            throw new WrappedException(ee);
        }
        if (e2 instanceof ParseException && ((ParseException)e2).isPromoted()) {
            throw e2;
        }
        if (this.options.getErrorMode(id) == 3) {
            throw new FatalParsingErrorException();
        }
    }

    @Override
    public void error(SAXParseException e2) throws SAXParseException {
        this.warning(null, 209, e2);
    }

    @Override
    public void warning(SAXParseException e2) throws SAXParseException {
        this.warning(null, 126, e2);
    }

    @Override
    public void fatalError(SAXParseException e2) throws SAXException {
        this.warning(null, 301, e2);
        throw new FatalParsingErrorException();
    }

    public void endLocalScope(ANode v) {
        if (this.handlers.getExtendedHandler() != nullScopeHandler) {
            ARPResource bn = (ARPResource)v;
            if (!bn.getHasBeenUsed()) {
                return;
            }
            if (bn.hasNodeID()) {
                if (this.handlers.getExtendedHandler().discardNodesWithNodeID()) {
                    return;
                }
                String bnodeID = bn.nodeID;
                if (!this.nodeIdUserData.containsKey(bnodeID)) {
                    this.nodeIdUserData.put(bnodeID, null);
                }
            } else {
                this.handlers.getExtendedHandler().endBNodeScope(bn);
            }
        }
    }

    public void endRDF() {
        this.handlers.getExtendedHandler().endRDF();
    }

    public void startRDF() {
        this.handlers.getExtendedHandler().startRDF();
    }

    boolean ignoring(int eCode) {
        return this.options.getErrorMode(eCode) == 0;
    }

    public boolean isError(int eCode) {
        return this.options.getErrorMode(eCode) == 2;
    }

    protected AbsXMLContext initialContext(String base, String lang) throws SAXParseException {
        return this.initialContextWithBase(base).withLang(this, lang);
    }

    private AbsXMLContext initialContextWithBase(String base) throws SAXParseException {
        this.allowRelativeReferences = false;
        if (base == null) {
            this.warning(null, 5, "Base URI not specified for input file; local URI references will be in error.");
            return new XMLBaselessContext(this, 211);
        }
        if (base.equals("")) {
            this.allowRelativeReferences = true;
            this.warning(null, 5, "Base URI specified as \"\"; local URI references will not be resolved.");
            return new XMLBaselessContext(this, 130);
        }
        return new XMLBaselessContext(this, 215).withBase(this, base);
    }

    StatementHandler getStatementHandler() {
        return this.handlers.getStatementHandler();
    }

    public ARPHandlers getHandlers() {
        return this.handlers;
    }

    public ARPOptions getOptions() {
        return this.options;
    }

    public void setOptionsWith(ARPOptions newOpts) {
        this.options = newOpts.copy();
    }

    public void setHandlersWith(ARPHandlers newHh) {
        this.handlers = ARPHandlers.createNewHandlers();
        this.handlers.setErrorHandler(newHh.getErrorHandler());
        this.handlers.setExtendedHandler(newHh.getExtendedHandler());
        this.handlers.setNamespaceHandler(newHh.getNamespaceHandler());
        this.handlers.setStatementHandler(newHh.getStatementHandler());
    }

    public void initParse(String base, String lang) throws SAXParseException {
        this.nodeIdUserData = new HashMap<String, Object>();
        this.idsUsed = this.ignoring(105) ? null : new HashMap();
        this.idsUsedCount = 0;
        this.frame = this.options.getEmbedding() ? new LookingForRDF(this, this.initialContext(base, lang)) : new StartStateRDForDescription(this, this.initialContext(base, lang));
    }

    void afterParse() {
        while (this.frame != null) {
            this.frame.abort();
            this.frame = this.frame.getParent();
        }
        this.endBnodeScope();
        this.idsUsed = null;
    }

    void endBnodeScope() {
        if (this.handlers.getExtendedHandler() != nullScopeHandler) {
            for (String nodeId : this.nodeIdUserData.keySet()) {
                ARPResource bn = new ARPResource(this, nodeId);
                this.handlers.getExtendedHandler().endBNodeScope(bn);
            }
        }
    }

    public ARPLocation location() {
        return new ARPLocation(this.locator);
    }

    IRIProvider iriProvider() {
        if (this.provider == null) {
            this.provider = this.options.getIRIProvider();
            if (this.provider == null) {
                this.provider = SystemIRIx.getProvider();
            }
        }
        return this.provider;
    }

    private void checkNamespaceURI(String uri) throws SAXParseException {
        ((Frame)this.frame).checkEncoding(null, uri);
        if (uri.length() != 0) {
            IRIx u = this.iriProvider().create(uri);
            try {
                u = IRIx.create(uri);
            }
            catch (IRIException ex) {
                u = IRIx.createAny(uri);
            }
            if (u.isRelative()) {
                this.warning(null, 109, "The namespace URI: <" + uri + "> is relative. Such use has been deprecated by the W3C, and may result in RDF interoperability failures. Use an absolute namespace URI.");
            }
            if (uri.startsWith(rdfns) && !uri.equals(rdfns)) {
                this.warning(null, 127, "Namespace URI ref <" + uri + "> may not be used in RDF/XML.");
            }
            if (uri.startsWith(xmlns) && !uri.equals(xmlns)) {
                this.warning(null, 128, "Namespace URI ref <" + uri + "> may not be used in RDF/XML.");
            }
        }
    }

    public boolean allowRelativeURIs() {
        return this.allowRelativeReferences;
    }

    public IRIx sameDocRef() {
        if (this.sameDocRef == null) {
            this.sameDocRef = this.iriProvider().create("");
        }
        return this.sameDocRef;
    }

    public void setBadStatementHandler(StatementHandler sh) {
        this.badStatementHandler = sh;
    }
}

