/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.runner;

import arq.cmdline.ModDatasetAssembler;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.main.runner.ServerArgs;
import org.apache.jena.fuseki.system.spot.TDBOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb2.DatabaseMgr;
import org.slf4j.Logger;

class DSGSetup {
    DSGSetup() {
    }

    static void setupTDB(Logger log2, String directory, boolean useTDB2, ServerArgs serverArgs) {
        File dir = Path.of(directory, new String[0]).toFile();
        if (!dir.exists()) {
            throw new CmdException("Directory does not exist: " + directory);
        }
        if (!dir.isDirectory()) {
            throw new CmdException("Not a directory: " + directory);
        }
        if (!dir.canRead()) {
            throw new CmdException("Directory not readable: " + directory);
        }
        if (!dir.canWrite()) {
            throw new CmdException("Directory not writeable: " + directory);
        }
        if (IO.isEmptyDirectory(directory)) {
            if (useTDB2) {
                DSGSetup.setupTDB2(log2, directory, serverArgs);
            } else {
                DSGSetup.setupTDB1(log2, directory, serverArgs);
            }
            return;
        }
        if (TDBOps.isTDB1(directory)) {
            DSGSetup.setupTDB1(log2, directory, serverArgs);
            return;
        }
        if (TDBOps.isTDB2(directory)) {
            DSGSetup.setupTDB2(log2, directory, serverArgs);
            return;
        }
        throw new CmdException("Directory not a database: " + directory);
    }

    private static void setupTDB1(Logger log2, String directory, ServerArgs serverArgs) {
        serverArgs.datasetDescription = "TDB1 dataset: location=" + directory;
        serverArgs.dataset = TDB1Factory.createDatasetGraph(directory);
    }

    private static void setupTDB2(Logger log2, String directory, ServerArgs serverArgs) {
        serverArgs.datasetDescription = "TDB2 dataset: location=" + directory;
        serverArgs.dataset = DatabaseMgr.connectDatasetGraph(directory);
    }

    static void setupMemTDB(Logger log2, boolean useTDB2, ServerArgs serverArgs) {
        String tag = useTDB2 ? "TDB2" : "TDB1";
        serverArgs.datasetDescription = tag + " dataset in-memory";
        serverArgs.dataset = useTDB2 ? DatabaseMgr.createDatasetGraph() : TDB1Factory.createDatasetGraph();
        serverArgs.allowUpdate = true;
    }

    static void setupMem(Logger log2, ServerArgs serverArgs) {
        serverArgs.datasetDescription = "in-memory";
        serverArgs.dataset = DatasetGraphFactory.createTxnMem();
        serverArgs.allowUpdate = true;
    }

    static void setupFile(Logger log2, List<String> filenames, ServerArgs serverArgs) {
        serverArgs.datasetDescription = "in-memory, with files loaded";
        serverArgs.dataset = DatasetGraphFactory.createTxnMem();
        Iterator<String> iterator = filenames.iterator();
        while (iterator.hasNext()) {
            String filename;
            String pathname = filename = iterator.next();
            if (filename.startsWith("file:")) {
                pathname = filename.substring("file:".length());
            }
            if (!FileOps.exists(pathname)) {
                throw new CmdException("File not found: " + filename);
            }
            Lang language = RDFLanguages.filenameToLang(filename);
            if (language == null) {
                throw new CmdException("Cannot guess language for file: " + filename);
            }
            Txn.executeWrite(serverArgs.dataset, () -> {
                try {
                    log2.info("Dataset: in-memory: load file: " + filename);
                    RDFDataMgr.read(serverArgs.dataset, filename);
                }
                catch (RiotException ex) {
                    throw new CmdException("Failed to load file: " + filename);
                }
            });
        }
    }

    static void setupAssembler(Logger log2, ModDatasetAssembler modDataset, ServerArgs serverArgs) {
        serverArgs.datasetDescription = "Assembler: " + modDataset.getAssemblerFile();
        Dataset ds = modDataset.createDataset();
        serverArgs.dataset = ds.asDatasetGraph();
    }

    static void setupRDFS(Logger serverlog, Graph rdfsSchemaGraph, ServerArgs serverArgs) {
        serverArgs.datasetDescription = serverArgs.datasetDescription == null ? "RDFS" : serverArgs.datasetDescription + " (with RDFS)";
        serverArgs.dataset = RDFSFactory.datasetRDFS(serverArgs.dataset, rdfsSchemaGraph);
    }
}

