/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;

public class XSDDuration {
    public static int durationCompare(Duration duration1, Duration duration2) {
        DurationVS vs1 = XSDDuration.durationClassify(duration1);
        DurationVS vs2 = XSDDuration.durationClassify(duration2);
        try {
            if (vs1.equals((Object)vs2)) {
                int x = duration1.compare(duration2);
                if (x == -1 || x == 0 || x == 1) {
                    return x;
                }
                return 2;
            }
            if (XSDDuration.durationIsZero$(duration1) && XSDDuration.durationIsZero$(duration2)) {
                return 0;
            }
            return -9;
        }
        catch (UnsupportedOperationException ex) {
            return 2;
        }
    }

    public static boolean durationIsZero(Duration duration) {
        if (!XSDDuration.durationIsSet(duration)) {
            return false;
        }
        return XSDDuration.durationIsZero$(duration);
    }

    private static boolean durationIsZero$(Duration duration) {
        return XSDDuration.zeroField(duration, DatatypeConstants.YEARS) && XSDDuration.zeroField(duration, DatatypeConstants.MONTHS) && XSDDuration.zeroField(duration, DatatypeConstants.DAYS) && XSDDuration.zeroField(duration, DatatypeConstants.HOURS) && XSDDuration.zeroField(duration, DatatypeConstants.MINUTES) && XSDDuration.zeroField(duration, DatatypeConstants.SECONDS);
    }

    private static boolean zeroField(Duration duration, DatatypeConstants.Field field) {
        return !duration.isSet(field) || duration.getField(field).intValue() == 0;
    }

    private static boolean durationIsSet(Duration duration) {
        boolean isSetYear = duration.isSet(DatatypeConstants.YEARS);
        boolean isSetMonth = duration.isSet(DatatypeConstants.MONTHS);
        boolean isSetDay = duration.isSet(DatatypeConstants.DAYS);
        boolean isSetHour = duration.isSet(DatatypeConstants.HOURS);
        boolean isSetMinute = duration.isSet(DatatypeConstants.MINUTES);
        boolean isSetSeconds = duration.isSet(DatatypeConstants.SECONDS);
        return isSetYear || isSetMonth || isSetDay || isSetHour || isSetMinute || isSetSeconds;
    }

    private static DurationVS durationClassify(Duration duration) {
        boolean isSetYear = duration.isSet(DatatypeConstants.YEARS);
        boolean isSetMonth = duration.isSet(DatatypeConstants.MONTHS);
        boolean isSetDay = duration.isSet(DatatypeConstants.DAYS);
        boolean isSetHour = duration.isSet(DatatypeConstants.HOURS);
        boolean isSetMinute = duration.isSet(DatatypeConstants.MINUTES);
        boolean isSetSeconds = duration.isSet(DatatypeConstants.SECONDS);
        if (!(isSetYear || isSetMonth || isSetDay || isSetHour || isSetMinute || isSetSeconds)) {
            return DurationVS.DURATION;
        }
        if (!isSetYear && !isSetMonth) {
            return DurationVS.DAYTIME;
        }
        if (!(isSetDay || isSetHour || isSetMinute || isSetSeconds)) {
            return DurationVS.YEARMONTH;
        }
        return DurationVS.DURATION;
    }

    private static enum DurationVS {
        YEARMONTH,
        DAYTIME,
        DURATION;

    }
}

