/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.Chars3986;
import org.apache.jena.rfc3986.ParseErrorIRI3986;

public class ParseIPv4Address {
    public static void checkIPv4(CharSequence string) {
        ParseIPv4Address.checkIPv4(string, 0, string.length());
    }

    public static void checkIPv4(CharSequence string, int start, int end) {
        int length = string.length();
        if (start < 0 || end < 0 || end > length) {
            throw new IllegalArgumentException();
        }
        if (length == 0 || start >= end) {
            throw ParseErrorIRI3986.parseError(string, "Empty IPv4 address");
        }
        ParseIPv4Address.parseIPv4(string, start, end);
    }

    private static int parseIPv4(CharSequence string, int start, int end) {
        int q = ParseIPv4Address.ipv4(string, start, end);
        if (q != end) {
            throw ParseErrorIRI3986.parseError(string, "IPV4 address too long (final dec-octet too long)");
        }
        return q;
    }

    static int ipv4(CharSequence string, int start, int end) {
        int p = start;
        for (int i = 0; i < 4; ++i) {
            char ch;
            int x = ParseIPv4Address.ipv4_digits(string, p, end);
            if (x < 0 || x == p) {
                throw ParseErrorIRI3986.parseError(string, "Bad IPv4 address (no digits)");
            }
            if (x - p == 3) {
                ParseIPv4Address.checkIPv4Value(string, p);
            }
            if (i != 3 && (ch = Chars3986.charAt(string, x)) != '.') {
                throw ParseErrorIRI3986.parseError(string, "Bad IPv4 address (dot not found after 3 digits)");
            }
            p = ++x;
        }
        return p;
    }

    private static int ipv4_digits(CharSequence string, int start, int end) {
        int p = start;
        for (int i = 0; i < 3; ++i) {
            if (p + i >= string.length()) {
                return p + i;
            }
            char ch = Chars3986.charAt(string, p + i);
            if (Chars3986.range(ch, 48, 57)) continue;
            return p + i;
        }
        return p + 3;
    }

    private static void checkIPv4Value(CharSequence string, int p) {
        char ch3;
        char ch2;
        char ch1 = Chars3986.charAt(string, p);
        int v = (ch1 - 48) * 100 + ((ch2 = Chars3986.charAt(string, p + 1)) - 48) * 10 + ((ch3 = Chars3986.charAt(string, p + 2)) - 48);
        if (v > 255) {
            throw ParseErrorIRI3986.parseError(string, "IPv4 number out of range 0-255.");
        }
    }

    private static int peekForIPv4(CharSequence string, int start, int end) {
        char ch;
        int i;
        boolean isIPv4 = false;
        int countDot = 0;
        int firstDot = 0;
        int p = -1;
        for (i = 0; i < 15 && (p = end - i - 1) >= 0; ++i) {
            ch = Chars3986.charAt(string, p);
            if (ch == '.') {
                isIPv4 = true;
                firstDot = p;
                if (++countDot != 3) continue;
                break;
            }
            if (!Chars3986.range(ch, 48, 57)) break;
        }
        if (!isIPv4) {
            return -1;
        }
        if (countDot != 3) {
            throw ParseErrorIRI3986.parseError(string, "Malformed IPv4 address as part of IPv6 []");
        }
        for (i = 0; i < 3 && (p = firstDot - i - 1) >= 0 && Chars3986.range(ch = Chars3986.charAt(string, p), 48, 57); ++i) {
        }
        char ch2 = Chars3986.charAt(string, p - 1);
        if (ch2 != ':') {
            throw ParseErrorIRI3986.parseError(string, "Malformed IPv4 address as part of IPv6; can't find ':' separator");
        }
        return p;
    }
}

