/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import org.apache.iceberg.variants.BasicType;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.SerializedArray;
import org.apache.iceberg.variants.SerializedObject;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.SerializedShortString;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;

public interface VariantValue {
    public PhysicalType type();

    public int sizeInBytes();

    public int writeTo(ByteBuffer var1, int var2);

    default public VariantPrimitive<?> asPrimitive() {
        throw new IllegalArgumentException("Not a primitive: " + String.valueOf(this));
    }

    default public VariantObject asObject() {
        throw new IllegalArgumentException("Not an object: " + String.valueOf(this));
    }

    default public VariantArray asArray() {
        throw new IllegalArgumentException("Not an array: " + String.valueOf(this));
    }

    public static VariantValue from(VariantMetadata metadata, ByteBuffer value) {
        int header = VariantUtil.readByte(value, 0);
        BasicType basicType = VariantUtil.basicType(header);
        switch (basicType) {
            case PRIMITIVE: {
                return SerializedPrimitive.from(value, header);
            }
            case SHORT_STRING: {
                return SerializedShortString.from(value, header);
            }
            case OBJECT: {
                return SerializedObject.from(metadata, value, header);
            }
            case ARRAY: {
                return SerializedArray.from(metadata, value, header);
            }
        }
        throw new UnsupportedOperationException("Unsupported basic type: " + String.valueOf((Object)basicType));
    }
}

