/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.AccessControlType;
import com.azure.storage.file.datalake.models.RolePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class PathAccessControlEntry {
    static final String ACCESS_CONTROL_ENTRY_INVALID_SCOPE = "Scope must be default or otherwise omitted";
    static final String DEFAULT_SCOPE = "default";
    private boolean defaultScope;
    private AccessControlType accessControlType;
    private String entityId;
    private RolePermissions permissions = new RolePermissions();

    public PathAccessControlEntry() {
        this.accessControlType = new AccessControlType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAccessControlEntry that = (PathAccessControlEntry)o;
        if (this.defaultScope != that.defaultScope) {
            return false;
        }
        if (this.accessControlType != that.accessControlType) {
            return false;
        }
        if (!Objects.equals(this.entityId, that.entityId)) {
            return false;
        }
        return Objects.equals(this.permissions, that.permissions);
    }

    public int hashCode() {
        int result = this.defaultScope ? 1 : 0;
        result = 31 * result + (this.accessControlType != null ? this.accessControlType.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
        return result;
    }

    public String toString() {
        StorageImplUtils.assertNotNull((String)"accessControlType", (Object)((Object)this.accessControlType));
        StorageImplUtils.assertNotNull((String)"permissions", (Object)this.permissions);
        StringBuilder sb = new StringBuilder();
        if (this.defaultScope) {
            sb.append("default:");
        }
        sb.append(this.accessControlType.toString().toLowerCase(Locale.ROOT));
        sb.append(':');
        sb.append(this.entityId == null ? "" : this.entityId);
        sb.append(':');
        sb.append(this.permissions.toSymbolic());
        return sb.toString();
    }

    public static PathAccessControlEntry parse(String str) {
        PathAccessControlEntry res = new PathAccessControlEntry();
        String[] parts = str.split(":");
        int indexOffset = 0;
        StorageImplUtils.assertInBounds((String)"parts.length", (long)parts.length, (long)3L, (long)4L);
        if (parts.length == 4) {
            if (!parts[0].equals(DEFAULT_SCOPE)) {
                throw new IllegalArgumentException(ACCESS_CONTROL_ENTRY_INVALID_SCOPE);
            }
            res.defaultScope = true;
            indexOffset = 1;
        }
        res.accessControlType = AccessControlType.fromString(parts[indexOffset]);
        res.entityId = !parts[1 + indexOffset].equals("") ? parts[1 + indexOffset] : null;
        res.permissions = RolePermissions.parseSymbolic(parts[2 + indexOffset], false);
        return res;
    }

    public static String serializeList(List<PathAccessControlEntry> acl) {
        StringBuilder sb = new StringBuilder();
        for (PathAccessControlEntry entry : acl) {
            sb.append(entry.toString());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static List<PathAccessControlEntry> parseList(String str) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(",");
        ArrayList<PathAccessControlEntry> acl = new ArrayList<PathAccessControlEntry>(strs.length);
        for (String entry : strs) {
            acl.add(PathAccessControlEntry.parse(entry));
        }
        return acl;
    }

    public boolean isInDefaultScope() {
        return this.defaultScope;
    }

    public AccessControlType getAccessControlType() {
        return this.accessControlType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public RolePermissions getPermissions() {
        return this.permissions;
    }

    public PathAccessControlEntry setDefaultScope(boolean defaultScope) {
        this.defaultScope = defaultScope;
        return this;
    }

    public PathAccessControlEntry setAccessControlType(AccessControlType accessControlType) {
        this.accessControlType = accessControlType;
        return this;
    }

    public PathAccessControlEntry setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public PathAccessControlEntry setPermissions(RolePermissions permissions) {
        this.permissions = permissions;
        return this;
    }
}

