/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropZoneEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;

public class SetDefaultZoneEntry
implements UpdateEntry,
Fireable {
    private final int zoneId;

    public SetDefaultZoneEntry(int zoneId) {
        this.zoneId = zoneId;
    }

    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.SET_DEFAULT_ZONE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SET_DEFAULT_ZONE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropZoneEventParameters(causalityToken, catalogVersion, this.zoneId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), catalog.schemas(), this.zoneId);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

