/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.api.AntiHijackAsyncResultSet;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteSql
implements IgniteSql,
Wrapper {
    private final IgniteSql sql;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteSql(IgniteSql sql, Executor asyncContinuationExecutor) {
        this.sql = sql;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public Statement createStatement(String query) {
        return (Statement)PublicApiThreading.execUserSyncOperation(() -> this.sql.createStatement(query));
    }

    public Statement.StatementBuilder statementBuilder() {
        return (Statement.StatementBuilder)PublicApiThreading.execUserSyncOperation(() -> ((IgniteSql)this.sql).statementBuilder());
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (ResultSet)PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, cancellationToken, query, arguments));
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (ResultSet)PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, cancellationToken, statement, arguments));
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (ResultSet)PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, mapper, cancellationToken, query, arguments));
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (ResultSet)PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, mapper, cancellationToken, statement, arguments));
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, cancellationToken, query, arguments));
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, cancellationToken, statement, arguments));
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, mapper, cancellationToken, query, arguments));
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, mapper, cancellationToken, statement, arguments));
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return (long[])PublicApiThreading.execUserSyncOperation(() -> this.sql.executeBatch(transaction, cancellationToken, dmlQuery, batch));
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return (long[])PublicApiThreading.execUserSyncOperation(() -> this.sql.executeBatch(transaction, cancellationToken, dmlStatement, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return this.doAsyncOperation(() -> this.sql.executeBatchAsync(transaction, cancellationToken, query, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        return this.doAsyncOperation(() -> this.sql.executeBatchAsync(transaction, cancellationToken, statement, batch));
    }

    public void executeScript(String query, Object ... arguments) {
        PublicApiThreading.execUserSyncOperation(() -> this.sql.executeScript(query, arguments));
    }

    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        PublicApiThreading.execUserSyncOperation(() -> this.sql.executeScript(cancellationToken, query, arguments));
    }

    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return this.doAsyncOperation(() -> this.sql.executeScriptAsync(query, arguments));
    }

    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperation(() -> this.sql.executeScriptAsync(cancellationToken, query, arguments));
    }

    private <T> CompletableFuture<AsyncResultSet<T>> doAsyncOperationForResultSet(Supplier<CompletableFuture<AsyncResultSet<T>>> operation) {
        return this.doAsyncOperation(operation).thenApply(resultSet -> new AntiHijackAsyncResultSet(resultSet, this.asyncContinuationExecutor));
    }

    private <T> CompletableFuture<T> doAsyncOperation(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack((CompletableFuture)future, (Executor)this.asyncContinuationExecutor);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)Wrappers.unwrap((Object)this.sql, classToUnwrap);
    }
}

