/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.node;

import jakarta.inject.Inject;
import java.net.URL;
import org.apache.ignite.internal.cli.core.converters.RestEndpointUrlConverter;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite.internal.cli.core.repl.registry.NodeNameRegistry;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public class NodeUrlMixin {
    @CommandLine.ArgGroup
    private Options options;
    @Inject
    private NodeNameRegistry nodeNameRegistry;

    @Nullable
    public String getNodeUrl() {
        if (this.options != null) {
            if (this.options.nodeUrl != null) {
                return this.options.nodeUrl.toString();
            }
            if (this.options.nodeName != null) {
                return this.nodeNameRegistry.nodeUrlByName(this.options.nodeName).orElseThrow(() -> new IgniteCliException("Node " + this.options.nodeName + " not found. Provide a valid name or use a URL"));
            }
        }
        return null;
    }

    private static class Options {
        @CommandLine.Option(names={"--url"}, description={"URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used"}, converter={RestEndpointUrlConverter.class}, defaultValue="_NULL_")
        private URL nodeUrl;
        @CommandLine.Option(names={"-n", "--node"}, description={"The name of the node to perform the operation on. Node names can be seen in the output of the 'cluster topology' command"}, defaultValue="_NULL_")
        private String nodeName;

        private Options() {
        }
    }
}

