/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;

public class WeightedEdgeStep {
    private final EdgeStep edgeStep;
    private final PropertyKey weightBy;
    private final double defaultWeight;
    private final long sample;

    public WeightedEdgeStep(HugeGraph g, Directions direction) {
        this(g, direction, (List<String>)ImmutableList.of());
    }

    public WeightedEdgeStep(HugeGraph g, List<String> labels) {
        this(g, Directions.BOTH, labels);
    }

    public WeightedEdgeStep(HugeGraph g, Map<String, Object> properties) {
        this(g, Directions.BOTH, (List<String>)ImmutableList.of(), properties);
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels) {
        this(g, direction, labels, (Map<String, Object>)ImmutableMap.of());
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties) {
        this(g, direction, labels, properties, Long.parseLong("10000"), 0L, null, 0.0, Long.parseLong("100"));
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties, long maxDegree, long skipDegree, String weightBy, double defaultWeight, long sample) {
        E.checkArgument((sample > 0L || sample == -1L ? 1 : 0) != 0, (String)"The sample must be > 0 or == -1, but got: %s", (Object[])new Object[]{sample});
        E.checkArgument((maxDegree == -1L || maxDegree >= sample ? 1 : 0) != 0, (String)"The max degree must be greater than or equal to sample, but got max degree %s and sample %s", (Object[])new Object[]{maxDegree, sample});
        this.edgeStep = new EdgeStep(g, direction, labels, properties, maxDegree, skipDegree);
        this.weightBy = weightBy != null ? g.propertyKey(weightBy) : null;
        this.defaultWeight = defaultWeight;
        this.sample = sample;
    }

    public EdgeStep step() {
        return this.edgeStep;
    }

    public PropertyKey weightBy() {
        return this.weightBy;
    }

    public double defaultWeight() {
        return this.defaultWeight;
    }

    public long sample() {
        return this.sample;
    }
}

