/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.computer;

import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.job.ComputerJob;
import org.apache.hugegraph.job.Job;
import org.apache.hugegraph.job.computer.Computer;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.ParameterUtil;
import org.slf4j.Logger;

public abstract class AbstractComputer
implements Computer {
    private static final Logger LOG = Log.logger(AbstractComputer.class);
    private static final String HADOOP_HOME = "HADOOP_HOME";
    private static final String COMMON = "common";
    private static final String ENV = "env";
    private static final String COMPUTER_HOME = "computer_home";
    private static final String MINUS_C = "-C";
    private static final String EQUAL = "=";
    private static final String SPACE = " ";
    private static final String MAIN_COMMAND = "%s/bin/hadoop jar hugegraph-computer.jar com.baidu.hugegraph.Computer -D libjars=./hugegraph-computer-core.jar";
    public static final String MAX_STEPS = "max_steps";
    public static final int DEFAULT_MAX_STEPS = 5;
    public static final String PRECISION = "precision";
    public static final double DEFAULT_PRECISION = 1.0E-4;
    public static final String TIMES = "times";
    public static final int DEFAULT_TIMES = 10;
    public static final String DIRECTION = "direction";
    public static final String DEGREE = "degree";
    public static final long DEFAULT_DEGREE = 100L;
    protected static final String CATEGORY_RANK = "rank";
    protected static final String CATEGORY_COMM = "community";
    private YAMLConfiguration config;
    private Map<String, Object> commonConfig = new HashMap<String, Object>();

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        E.checkArgument((boolean)parameters.isEmpty(), (String)"Unnecessary parameters: %s", (Object[])new Object[]{parameters});
    }

    @Override
    public Object call(Job<Object> job, Map<String, Object> parameters) {
        this.checkAndCollectParameters(parameters);
        try {
            this.initializeConfig((ComputerJob)job);
        }
        catch (Exception e) {
            throw new HugeException("Failed to initialize computer config file", e);
        }
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.putAll(this.commonConfig);
        configs.putAll(this.checkAndCollectParameters(parameters));
        CharSequence[] command = this.constructShellCommands(configs);
        LOG.info("Execute computer job: {}", (Object)String.join((CharSequence)SPACE, command));
        try {
            ProcessBuilder builder = new ProcessBuilder((String[])command);
            builder.redirectErrorStream(true);
            builder.directory(new File(this.executeDir()));
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return 0;
            }
            throw new HugeException("The computer job exit with code %s: %s", exitCode, output);
        }
        catch (HugeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new HugeException("Failed to execute computer job", e);
        }
    }

    private String executeDir() {
        Map<String, Object> envs = this.readEnvConfig();
        E.checkState((boolean)envs.containsKey(COMPUTER_HOME), (String)"Expect '%s' in '%s' section", (Object[])new Object[]{COMPUTER_HOME, ENV});
        return (String)envs.get(COMPUTER_HOME);
    }

    private void initializeConfig(ComputerJob job) throws Exception {
        String configPath = job.computerConfigPath();
        E.checkArgument((boolean)configPath.endsWith(".yaml"), (String)"Expect a yaml config file.", (Object[])new Object[0]);
        this.config = new YAMLConfiguration();
        FileHandler fileHandler = new FileHandler((FileBased)this.config);
        fileHandler.load(configPath);
        this.commonConfig = this.readCommonConfig();
    }

    private Map<String, Object> readCommonConfig() {
        return this.readSubConfig(COMMON);
    }

    private Map<String, Object> readEnvConfig() {
        return this.readSubConfig(ENV);
    }

    private Map<String, Object> readSubConfig(String sub) {
        List nodes = this.config.childConfigurationsAt(sub);
        E.checkArgument((nodes.size() >= 1 ? 1 : 0) != 0, (String)"'%s' must be contained in config '%s'", (Object[])new Object[]{sub});
        ImmutableNode root = null;
        HashMap<String, Object> results = new HashMap<String, Object>(nodes.size());
        for (HierarchicalConfiguration node : nodes) {
            NodeHandler nodeHandler;
            NodeModel nodeModel = node.getNodeModel();
            E.checkArgument((nodeModel != null && (nodeHandler = nodeModel.getNodeHandler()) != null && (root = (ImmutableNode)nodeHandler.getRootNode()) != null ? 1 : 0) != 0, (String)"Node '%s' must contain root", (Object[])new Object[]{node});
            results.put(root.getNodeName(), root.getValue());
        }
        return results;
    }

    private String[] constructShellCommands(Map<String, Object> configs) {
        String hadoopHome = System.getenv(HADOOP_HOME);
        String commandPrefix = String.format(MAIN_COMMAND, hadoopHome);
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(commandPrefix.split(SPACE)));
        command.add(this.name());
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            command.add(MINUS_C);
            command.add(entry.getKey() + EQUAL + entry.getValue());
        }
        return command.toArray(new String[0]);
    }

    protected abstract Map<String, Object> checkAndCollectParameters(Map<String, Object> var1);

    protected static int maxSteps(Map<String, Object> parameters) {
        if (!parameters.containsKey(MAX_STEPS)) {
            return 5;
        }
        int maxSteps = ParameterUtil.parameterInt(parameters, MAX_STEPS);
        E.checkArgument((maxSteps > 0 ? 1 : 0) != 0, (String)"The value of %s must be > 0, but got %s", (Object[])new Object[]{MAX_STEPS, maxSteps});
        return maxSteps;
    }

    protected static double precision(Map<String, Object> parameters) {
        if (!parameters.containsKey(PRECISION)) {
            return 1.0E-4;
        }
        double precision = ParameterUtil.parameterDouble(parameters, PRECISION);
        E.checkArgument((precision > 0.0 && precision < 1.0 ? 1 : 0) != 0, (String)"The value of %s must be (0, 1), but got %s", (Object[])new Object[]{PRECISION, precision});
        return precision;
    }

    protected static int times(Map<String, Object> parameters) {
        if (!parameters.containsKey(TIMES)) {
            return 10;
        }
        int times = ParameterUtil.parameterInt(parameters, TIMES);
        E.checkArgument((times > 0 ? 1 : 0) != 0, (String)"The value of %s must be > 0, but got %s", (Object[])new Object[]{TIMES, times});
        return times;
    }

    protected static Directions direction(Map<String, Object> parameters) {
        if (!parameters.containsKey(DIRECTION)) {
            return Directions.BOTH;
        }
        Object direction = ParameterUtil.parameter(parameters, DIRECTION);
        return AbstractComputer.parseDirection(direction);
    }

    protected static long degree(Map<String, Object> parameters) {
        if (!parameters.containsKey(DEGREE)) {
            return 100L;
        }
        long degree = ParameterUtil.parameterLong(parameters, DEGREE);
        HugeTraverser.checkDegree(degree);
        return degree;
    }

    protected static Directions parseDirection(Object direction) {
        if (direction.equals(Directions.BOTH.toString())) {
            return Directions.BOTH;
        }
        if (direction.equals(Directions.OUT.toString())) {
            return Directions.OUT;
        }
        if (direction.equals(Directions.IN.toString())) {
            return Directions.IN;
        }
        throw new IllegalArgumentException(String.format("The value of direction must be in [OUT, IN, BOTH], but got '%s'", direction));
    }
}

