/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.tire.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nlpcn.commons.lang.tire.SmartGetWord;

public class SmartForest<T>
implements Comparable<SmartForest<T>>,
Serializable {
    private static final long serialVersionUID = -6088248882078972772L;
    private static final int MAX_SIZE = 65536;
    public SmartForest<T>[] branches = null;
    SmartForest<T> branch = null;
    private double rate = 0.9;
    private char c;
    private byte status = 1;
    private T param = null;

    public SmartForest() {
    }

    public SmartForest(double rate) {
        this.branches = new SmartForest[65536];
        this.rate = rate;
    }

    private SmartForest(char c) {
        this.c = c;
    }

    public SmartForest(char c, int status, T param) {
        this.c = c;
        this.status = (byte)status;
        this.param = param;
    }

    public synchronized SmartForest<T> add(SmartForest<T> branch) {
        int bs;
        if (this.branches == null) {
            this.branches = new SmartForest[0];
        }
        if ((bs = this.getIndex(branch.getC())) > -1) {
            if (this.branches[bs] == null) {
                this.branches[bs] = branch;
            }
            this.branch = this.branches[bs];
            switch (branch.getStatus()) {
                case -1: {
                    this.branch.setStatus(1);
                    break;
                }
                case 1: {
                    if (this.branch.getStatus() != 3) break;
                    this.branch.setStatus(2);
                    break;
                }
                case 3: {
                    if (this.branch.getStatus() != 3) {
                        this.branch.setStatus(2);
                    }
                    this.branch.setParam(branch.getParam());
                }
            }
            return this.branch;
        }
        if (bs < 0) {
            if (this.branches != null && (double)this.branches.length >= 65536.0 * this.rate) {
                SmartForest[] tempBranches = new SmartForest[65536];
                SmartForest<T>[] smartForestArray = this.branches;
                int n = smartForestArray.length;
                for (int i = 0; i < n; ++i) {
                    SmartForest<T> b;
                    tempBranches[b.getC()] = b = smartForestArray[i];
                }
                tempBranches[branch.getC()] = branch;
                this.branches = null;
                this.branches = tempBranches;
            } else {
                SmartForest[] newBranches = new SmartForest[this.branches.length + 1];
                int insert = -(bs + 1);
                System.arraycopy(this.branches, 0, newBranches, 0, insert);
                System.arraycopy(this.branches, insert, newBranches, insert + 1, this.branches.length - insert);
                newBranches[insert] = branch;
                this.branches = newBranches;
            }
        }
        return branch;
    }

    public int getIndex(char c) {
        if (this.branches == null) {
            return -1;
        }
        if (this.branches.length == 65536) {
            return c;
        }
        int i = Arrays.binarySearch(this.branches, new SmartForest<T>(c));
        return i;
    }

    public boolean contains(char c) {
        if (this.branches == null) {
            return false;
        }
        return Arrays.binarySearch(this.branches, Character.valueOf(c)) > -1;
    }

    @Override
    public int compareTo(char c) {
        if (this.c > c) {
            return 1;
        }
        if (this.c < c) {
            return -1;
        }
        return 0;
    }

    public boolean equals(char c) {
        return this.c == c;
    }

    public int hashCode() {
        return this.c;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = (byte)status;
    }

    public char getC() {
        return this.c;
    }

    public T getParam() {
        return this.param;
    }

    public void setParam(T param) {
        this.param = param;
    }

    public void add(String keyWord, T t) {
        SmartForest<T> tempBranch = this;
        for (int i = 0; i < keyWord.length(); ++i) {
            if (keyWord.length() == i + 1) {
                tempBranch.add(new SmartForest<T>(keyWord.charAt(i), 3, t));
            } else {
                tempBranch.add(new SmartForest<Object>(keyWord.charAt(i), 1, null));
            }
            tempBranch = tempBranch.branches[tempBranch.getIndex(keyWord.charAt(i))];
        }
    }

    public void addBranch(String keyWord, T t) {
        this.add(keyWord, t);
    }

    @Override
    public int compareTo(SmartForest<T> o) {
        if (this.c > o.c) {
            return 1;
        }
        if (this.c < o.c) {
            return -1;
        }
        return 0;
    }

    public SmartForest<T> get(char c) {
        return this.getBranch(c);
    }

    public SmartForest<T> getBranch(char c) {
        int index = this.getIndex(c);
        if (index < 0) {
            return null;
        }
        return this.branches[index];
    }

    public SmartForest<T> getBranch(String keyWord) {
        SmartForest<T> tempBranch = this;
        int index = 0;
        for (int j = 0; j < keyWord.length(); ++j) {
            index = tempBranch.getIndex(keyWord.charAt(j));
            if (index < 0) {
                return null;
            }
            tempBranch = tempBranch.branches[index];
            if (tempBranch != null) continue;
            return null;
        }
        return tempBranch;
    }

    public SmartForest<T> getBranch(char[] chars) {
        SmartForest<T> tempBranch = this;
        int index = 0;
        for (int j = 0; j < chars.length; ++j) {
            index = tempBranch.getIndex(chars[j]);
            if (index < 0) {
                return null;
            }
            tempBranch = tempBranch.branches[index];
            if (tempBranch != null) continue;
            return null;
        }
        return tempBranch;
    }

    public SmartGetWord<T> getWord(String str) {
        return this.getWord(str.toCharArray());
    }

    public SmartGetWord<T> getWord(char[] chars) {
        return new SmartGetWord(this, chars);
    }

    public SmartForest<T>[] getBranches() {
        return this.branches;
    }

    public void remove(String word) {
        this.getBranch((String)word).status = 1;
        this.getBranch((String)word).param = null;
    }

    public void clear() {
        this.branches = new SmartForest[65536];
    }

    public Map<String, T> toMap() {
        HashMap result = new HashMap();
        if (this.branches == null) {
            return result;
        }
        this.putMap(result, "", this.branches);
        return result;
    }

    private void putMap(HashMap<String, T> result, String pre, SmartForest<T>[] branches) {
        if (branches == null) {
            return;
        }
        String key = null;
        SmartForest<T> sf = null;
        for (int i = 0; i < branches.length; ++i) {
            sf = branches[i];
            if (sf == null) continue;
            key = pre + branches[i].c;
            if (branches[i].getStatus() == 3) {
                result.put(key, branches[i].getParam());
                continue;
            }
            if (branches[i].getStatus() == 2) {
                result.put(key, branches[i].getParam());
                this.putMap(result, key, sf.branches);
                continue;
            }
            this.putMap(result, key, sf.branches);
        }
    }
}

