/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.exception.HugeGremlinException;
import org.apache.hugegraph.exception.NotFoundException;
import org.glassfish.hk2.api.MultiException;

public class ExceptionFilter {
    private static final int BAD_REQUEST_ERROR = Response.Status.BAD_REQUEST.getStatusCode();
    private static final int NOT_FOUND_ERROR = Response.Status.NOT_FOUND.getStatusCode();
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();

    public static String formatException(Throwable exception, boolean trace) {
        String clazz = exception.getClass().toString();
        String message = exception.getMessage() != null ? exception.getMessage() : "";
        String cause = exception.getCause() != null ? exception.getCause().toString() : "";
        JsonObjectBuilder json = Json.createObjectBuilder().add("exception", clazz).add("message", message).add("cause", cause);
        if (trace) {
            JsonArrayBuilder traces = Json.createArrayBuilder();
            for (StackTraceElement i : exception.getStackTrace()) {
                traces.add(i.toString());
            }
            json.add("trace", traces);
        }
        return json.build().toString();
    }

    public static String formatGremlinException(HugeGremlinException exception, boolean trace) {
        Map map = exception.response();
        String message = (String)map.get("message");
        String exClassName = (String)map.get("Exception-Class");
        List exceptions = (List)map.get("exceptions");
        String stackTrace = (String)map.get("stackTrace");
        message = message != null ? message : "";
        exClassName = exClassName != null ? exClassName : "";
        String cause = exceptions != null ? exceptions.toString() : "";
        JsonObjectBuilder json = Json.createObjectBuilder().add("exception", exClassName).add("message", message).add("cause", cause);
        if (trace && stackTrace != null) {
            JsonArrayBuilder traces = Json.createArrayBuilder();
            for (String part : StringUtils.split((String)stackTrace, (char)'\n')) {
                traces.add(part);
            }
            json.add("trace", traces);
        }
        return json.build().toString();
    }

    @Provider
    public static class UnknownExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<Throwable> {
        public Response toResponse(Throwable exception) {
            if (exception instanceof MultiException && ((MultiException)exception).getErrors().size() == 1) {
                exception = (Throwable)((MultiException)exception).getErrors().get(0);
            }
            return Response.status((int)INTERNAL_SERVER_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException(exception, this.trace())).build();
        }
    }

    @Provider
    public static class AssertionErrorMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<AssertionError> {
        public Response toResponse(AssertionError exception) {
            return Response.status((int)INTERNAL_SERVER_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException((Throwable)((Object)exception), true)).build();
        }
    }

    @Provider
    public static class HugeGremlinExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<HugeGremlinException> {
        public Response toResponse(HugeGremlinException exception) {
            return Response.status((int)exception.statusCode()).type("application/json").entity((Object)ExceptionFilter.formatGremlinException(exception, this.trace())).build();
        }
    }

    @Provider
    public static class WebApplicationExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<WebApplicationException> {
        public Response toResponse(WebApplicationException exception) {
            Response response = exception.getResponse();
            if (response.hasEntity()) {
                return response;
            }
            MultivaluedMap headers = response.getHeaders();
            boolean trace = this.trace(response.getStatus());
            response = Response.status((int)response.getStatus()).type("application/json").entity((Object)ExceptionFilter.formatException((Throwable)exception, trace)).build();
            response.getHeaders().putAll((Map)headers);
            return response;
        }

        private boolean trace(int status) {
            return this.trace() && status == INTERNAL_SERVER_ERROR;
        }
    }

    @Provider
    public static class NoSuchElementExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<NoSuchElementException> {
        public Response toResponse(NoSuchElementException exception) {
            return Response.status((int)NOT_FOUND_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException(exception, this.trace())).build();
        }
    }

    @Provider
    public static class NotFoundExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<NotFoundException> {
        public Response toResponse(NotFoundException exception) {
            return Response.status((int)NOT_FOUND_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException(exception, this.trace())).build();
        }
    }

    @Provider
    public static class IllegalArgumentExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<IllegalArgumentException> {
        public Response toResponse(IllegalArgumentException exception) {
            return Response.status((int)BAD_REQUEST_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException(exception, this.trace())).build();
        }
    }

    @Provider
    public static class HugeExceptionMapper
    extends TracedExceptionMapper
    implements ExceptionMapper<HugeException> {
        public Response toResponse(HugeException exception) {
            return Response.status((int)BAD_REQUEST_ERROR).type("application/json").entity((Object)ExceptionFilter.formatException((Throwable)exception, this.trace())).build();
        }
    }

    @Path(value="exception/trace")
    @Singleton
    @Tag(name="TracedExceptionAPI")
    public static class TracedExceptionAPI
    extends API {
        @GET
        @Timed
        @Produces(value={"application/json;charset=UTF-8"})
        @RolesAllowed(value={"admin"})
        public Object get() {
            return ImmutableMap.of((Object)"trace", (Object)TracedExceptionMapper.forcedTrace);
        }

        @PUT
        @Timed
        @Consumes(value={"application/json"})
        @Produces(value={"application/json;charset=UTF-8"})
        @RolesAllowed(value={"admin"})
        public Object trace(boolean trace) {
            TracedExceptionMapper.forcedTrace = trace;
            return ImmutableMap.of((Object)"trace", (Object)TracedExceptionMapper.forcedTrace);
        }
    }

    public static class TracedExceptionMapper
    extends API {
        private static boolean forcedTrace = false;
        @Context
        private jakarta.inject.Provider<HugeConfig> configProvider;

        protected boolean trace() {
            if (forcedTrace) {
                return true;
            }
            HugeConfig config = (HugeConfig)this.configProvider.get();
            if (config == null) {
                return false;
            }
            return (Boolean)config.get(ServerOptions.ALLOW_TRACE);
        }
    }
}

